/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import java.io.IOException;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public abstract class PSolQueryItem {
    private static final float PHRASE_TO_SPAN_TERM_POSITIONS_COST = 4.0f;
    private static final int TERM_POSNS_SEEK_OPS_PER_DOC = 128;
    private static final int TERM_OPS_PER_POS = 7;
    private boolean compoundPart = false;

    public abstract PSolWeightItem createWeightItem(IndexSearcher var1, ScoreMode var2, float var3) throws IOException;

    public void collectTerms(Query query, QueryVisitor visitor) {
    }

    public abstract String getSearchField();

    protected float termPositionsCost(TermsEnum termsEnum) throws IOException {
        int docFreq = termsEnum.docFreq();
        assert (docFreq > 0);
        long totalTermFreq = termsEnum.totalTermFreq();
        float expOccurrencesInMatchingDoc = totalTermFreq < (long)docFreq ? 1.0f : (float)totalTermFreq / (float)docFreq;
        return (128.0f + expOccurrencesInMatchingDoc * 7.0f) * 4.0f;
    }

    public void setCompoundPart(boolean yesno) {
        this.compoundPart = yesno;
    }

    public boolean isCompoundPart() {
        return this.compoundPart;
    }
}

