/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItemBoost;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public class PSolQueryItemBoost
extends PSolQueryItem {
    private final PSolQueryItem child;
    private final PSolBoost boost;

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        this.child.collectTerms(query, visitor);
    }

    @Override
    public String getSearchField() {
        return this.child.getSearchField();
    }

    public PSolQueryItemBoost(PSolQueryItem child, PSolBoost boost) {
        this.child = child;
        this.boost = boost;
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        PSolWeightItem subItem = this.child.createWeightItem(searcher, scoreMode, boost);
        if (subItem == null) {
            return null;
        }
        return new PSolWeightItemBoost(subItem, this.boost);
    }

    public String toString() {
        return this.child.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemBoost other = (PSolQueryItemBoost)obj;
        return this.child.equals(other.child);
    }

    public int hashCode() {
        int h = this.getClass().getName().hashCode();
        h = 31 * h + this.child.hashCode();
        return h;
    }

    public PSolQueryItem getChildItem() {
        return this.child;
    }
}

