/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItemOr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public class PSolQueryItemOr
extends PSolQueryItem {
    private final List<PSolQueryItem> itemList;
    private final List<ItemData> itemDataList;

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        if (this.itemList != null) {
            for (PSolQueryItem item : this.itemList) {
                item.collectTerms(query, visitor);
            }
        }
    }

    @Override
    public String getSearchField() {
        if (!this.itemList.isEmpty()) {
            return this.itemList.get(0).getSearchField();
        }
        return "";
    }

    public PSolQueryItemOr(List<PSolQueryItem> itemList) {
        this(itemList, null);
    }

    public PSolQueryItemOr(List<PSolQueryItem> itemList, List<ItemData> itemDataList) {
        assert (itemDataList == null || itemList.size() == itemDataList.size());
        this.itemList = itemList;
        this.itemDataList = itemDataList;
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ArrayList<PSolWeightItem> weightList = new ArrayList<PSolWeightItem>(this.itemList.size());
        for (int i = 0; i < this.itemList.size(); ++i) {
            PSolWeightItem subItem = this.itemList.get(i).createWeightItem(searcher, scoreMode, boost);
            if (subItem == null) {
                return null;
            }
            weightList.add(subItem);
        }
        return new PSolWeightItemOr(weightList, this.itemDataList);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (i != 0) {
                buffer.append('|');
            }
            buffer.append(this.itemList.get(i).toString());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemOr other = (PSolQueryItemOr)obj;
        return this.itemList.equals(other.itemList);
    }

    public int hashCode() {
        int h = this.getClass().getName().hashCode();
        h = 31 * h + this.itemList.hashCode();
        return h;
    }

    public List<PSolQueryItem> getItemList() {
        return this.itemList;
    }

    public static class ItemData {
        public final PSolBoost boost;
        public final int posBase;
        public final boolean optional;
        public final boolean projectField;

        public ItemData(PSolBoost boost, int posBase, boolean optional, boolean isProjectField) {
            this.boost = boost;
            this.posBase = posBase;
            this.optional = optional;
            this.projectField = isProjectField;
        }
    }
}

