/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeigthItemDefault;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public class PSolQueryItemTerm
extends PSolQueryItem {
    private final Term term;

    public PSolQueryItemTerm(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        visitor.consumeTerms(query, this.term);
    }

    @Override
    public String getSearchField() {
        return this.term.field();
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new PSolWeigthItemDefault(this){

            @Override
            public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
                TermsEnum te = context.getTermsEnum(PSolQueryItemTerm.this.term.field());
                if (te != null && te.seekExact(PSolQueryItemTerm.this.term.bytes())) {
                    PostingsEnum postingsEnum = te.postings(null, needPayload ? 88 : 24);
                    return new PostingsEnumData(postingsEnum, PSolQueryItemTerm.this.term, PSolQueryItemTerm.this.termPositionsCost(te));
                }
                return null;
            }

            @Override
            public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
                queryTerms.add(PSolQueryItemTerm.this.term);
            }

            @Override
            public String getSearchField() {
                return PSolQueryItemTerm.this.term.field();
            }
        };
    }

    public String toString() {
        return this.term.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemTerm other = (PSolQueryItemTerm)obj;
        if (this.term == null) {
            return other.term == null;
        }
        return this.term.equals(other.term);
    }

    public int hashCode() {
        return this.term.hashCode();
    }
}

