/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeigthItemDefault;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumDisjunct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;

public class PSolQueryItemTermList
extends PSolQueryItem {
    private final TermItem[] termList;

    public TermItem[] getTermList() {
        return this.termList;
    }

    public PSolQueryItemTermList(TermItem[] termList) {
        this.termList = termList;
    }

    @Override
    public void collectTerms(Query query, QueryVisitor visitor) {
        for (TermItem item : this.termList) {
            visitor.consumeTerms(query, item.term);
        }
    }

    @Override
    public String getSearchField() {
        return this.termList[0].term.field();
    }

    @Override
    public PSolWeightItem createWeightItem(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new PSolWeigthItemDefault(this){

            @Override
            public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
                TermsEnum te = context.getTermsEnum(PSolQueryItemTermList.this.termList[0].term.field());
                if (te == null) {
                    return null;
                }
                ArrayList<PostingsEnumDisjunct.Item> postList = new ArrayList<PostingsEnumDisjunct.Item>(PSolQueryItemTermList.this.termList.length);
                float matchCost = 0.0f;
                for (TermItem termItem : PSolQueryItemTermList.this.termList) {
                    Term term = termItem.term;
                    if (!te.seekExact(term.bytes())) continue;
                    PSolBoost boost = termItem.exactBoost;
                    PostingsEnum postingsEnum = te.postings(null, boost != null ? 88 : 24);
                    postList.add(new PostingsEnumDisjunct.Item(postingsEnum, term, boost, 0, false));
                    matchCost += PSolQueryItemTermList.this.termPositionsCost(te);
                }
                if (!postList.isEmpty()) {
                    if (postList.size() == 1) {
                        PostingsEnumDisjunct.Item item = (PostingsEnumDisjunct.Item)postList.get(0);
                        return new PostingsEnumData(item.postings, item.term, matchCost);
                    }
                    PostingsEnumDisjunct mpost = new PostingsEnumDisjunct(postList);
                    return new PostingsEnumData(mpost, null, matchCost);
                }
                return null;
            }

            @Override
            public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
                for (TermItem termItem : PSolQueryItemTermList.this.termList) {
                    queryTerms.add(termItem.term);
                }
            }

            @Override
            public String getSearchField() {
                return PSolQueryItemTermList.this.termList[0].term.field();
            }
        };
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.termList.length; ++i) {
            if (i != 0) {
                buffer.append('|');
            }
            buffer.append(this.termList[i].term.text());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSolQueryItemTermList other = (PSolQueryItemTermList)obj;
        return Arrays.equals(this.termList, other.termList);
    }

    public int hashCode() {
        int h = this.getClass().getName().hashCode();
        h = 31 * h + Arrays.hashCode(this.termList);
        return h;
    }

    public static class TermItem {
        private final Term term;
        private final PSolBoost exactBoost;

        public TermItem(Term term, PSolBoost exactBoost) {
            this.term = term;
            this.exactBoost = exactBoost;
        }

        public Term getTerm() {
            return this.term;
        }

        public double getBoost() {
            if (this.exactBoost != null) {
                return this.exactBoost.defaultBoost();
            }
            return Double.NaN;
        }
    }
}

