/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolExplain;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumWrapper;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class PSolWeighItemWrapper
extends PSolWeightItem {
    Weight weight;

    PSolWeighItemWrapper(Weight weight) {
        this.weight = weight;
    }

    @Override
    public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
        Scorer subScorer = this.weight.scorer(context.getLeafReaderContext());
        if (subScorer != null) {
            PSolExplain explain = new PSolExplain(){

                @Override
                public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                    return PSolWeighItemWrapper.this.weight.explain(context, doc);
                }
            };
            PostingsEnumWrapper postings = new PostingsEnumWrapper(subScorer, explain);
            return new PostingsEnumData(postings, null, ((DocIdSetIterator)postings).cost());
        }
        return null;
    }

    @Override
    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        Query query = this.weight.getQuery();
        if (query != null) {
            queryConsumer.accept(query);
        }
    }

    @Override
    public String getSearchField() {
        return "";
    }
}

