/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItemOr;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumDisjunct;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumOpt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public class PSolWeightItemOr
extends PSolWeightItem {
    private final List<PSolWeightItem> weightList;
    private final List<PSolQueryItemOr.ItemData> itemDataList;

    PSolWeightItemOr(List<PSolWeightItem> weightList, List<PSolQueryItemOr.ItemData> itemDataList) {
        this.weightList = weightList;
        this.itemDataList = itemDataList;
    }

    @Override
    public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
        float matchCostLead = 0.0f;
        float matchCostOpt = 0.0f;
        ArrayList<PostingsEnumDisjunct.Item> leadList = new ArrayList<PostingsEnumDisjunct.Item>(this.weightList.size());
        ArrayList<PostingsEnumDisjunct.Item> optList = new ArrayList<PostingsEnumDisjunct.Item>();
        boolean leadHasPosition = false;
        boolean optHasPosition = false;
        for (int i = 0; i < this.weightList.size(); ++i) {
            PSolWeightItem item = this.weightList.get(i);
            PostingsEnumData subData = item.getPostingsEnum(context, needPayload);
            if (subData == null || subData.postings == null) continue;
            if (this.itemDataList != null) {
                PSolQueryItemOr.ItemData connectData = this.itemDataList.get(i);
                PostingsEnumDisjunct.Item newItem = new PostingsEnumDisjunct.Item(subData.postings, subData.term, connectData.boost, connectData.posBase, connectData.projectField);
                if (connectData.optional) {
                    optList.add(newItem);
                    matchCostOpt += subData.matchCost;
                    if (connectData.boost == null || !connectData.boost.needPositions()) continue;
                    optHasPosition = true;
                    continue;
                }
                matchCostLead += subData.matchCost;
                leadList.add(newItem);
                if (connectData.boost == null || !connectData.boost.needPositions()) continue;
                leadHasPosition = true;
                continue;
            }
            leadList.add(new PostingsEnumDisjunct.Item(subData.postings, subData.term, null, 0, false));
            matchCostLead += subData.matchCost;
        }
        if (leadList.isEmpty()) {
            return null;
        }
        PostingsEnumDisjunct postListLead = new PostingsEnumDisjunct(leadList);
        PostingsEnumDisjunct postListOpt = null;
        if (optList.size() > 0) {
            postListOpt = new PostingsEnumDisjunct(optList);
        }
        PostingsEnumDisjunct postListScore = postListOpt == null || !optHasPosition || leadHasPosition ? postListLead : postListOpt;
        if (postListOpt == null) {
            return new PostingsEnumData(postListScore, null, matchCostLead);
        }
        PostingsEnumOpt postingResult = new PostingsEnumOpt(postListLead, postListOpt, postListScore, 0.2f);
        return new PostingsEnumData(postingResult, null, matchCostLead + matchCostOpt);
    }

    @Override
    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        for (PSolWeightItem item : this.weightList) {
            item.extractTerms(queryTerms, queryConsumer);
        }
    }

    @Override
    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        for (PSolWeightItem weightItem : this.weightList) {
            weightItem.extractWeightedSpanTerms(context, fieldName, terms, queryConsumer);
        }
    }

    @Override
    public String getSearchField() {
        if (!this.weightList.isEmpty()) {
            return this.weightList.get(0).getSearchField();
        }
        return "";
    }
}

