/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolWeightItem;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumPhraseCompound;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumPhraseStandard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.PositionSpan;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public class PSolWeightItemPhrase
extends PSolWeightItem {
    private final PSolWeightItem[] weightList;
    private final boolean isCompoundPhrase;
    private final boolean isStrict;

    PSolWeightItemPhrase(PSolWeightItem[] weightList, boolean isCompoundPhrase, boolean isStrict) {
        this.weightList = weightList;
        this.isCompoundPhrase = isCompoundPhrase;
        this.isStrict = isStrict;
    }

    @Override
    public PostingsEnumData getPostingsEnum(ContextCache context, boolean needPayload) throws IOException {
        if (this.isCompoundPhrase) {
            return this.getPostingEnumCompound(context, needPayload);
        }
        return this.getPostingEnumStandard(context, needPayload);
    }

    private PostingsEnumData getPostingEnumCompound(ContextCache context, boolean needPayload) throws IOException {
        float matchCost = 0.0f;
        String field = "";
        ArrayList<PostingsEnumPhraseCompound.Item> postList = new ArrayList<PostingsEnumPhraseCompound.Item>(this.weightList.length);
        for (int i = 0; i < this.weightList.length; ++i) {
            PSolWeightItem compoundItem;
            PSolWeightItem item = this.weightList[i];
            PostingsEnumData subData = item.getPostingsEnum(context, needPayload);
            if (field.isEmpty()) {
                field = item.getSearchField();
            }
            PostingsEnumPhraseCompound.Item postingItem = null;
            if (subData != null && subData.postings != null) {
                postingItem = new PostingsEnumPhraseCompound.Item(subData.postings, subData.term);
                matchCost += subData.matchCost;
            }
            ArrayList<PostingsEnumPhraseCompound.Item> compoundList = null;
            boolean found = false;
            for (int k = i + 1; k < this.weightList.length && (compoundItem = this.weightList[k]).isCompoundPart(); ++k) {
                ++i;
                PostingsEnumData compoundData = compoundItem.getPostingsEnum(context, needPayload);
                boolean bl = found = compoundData != null;
                if (!found) break;
                if (compoundList == null) {
                    compoundList = new ArrayList<PostingsEnumPhraseCompound.Item>();
                }
                compoundList.add(new PostingsEnumPhraseCompound.Item(compoundData.postings, compoundData.term));
                matchCost += compoundData.matchCost;
            }
            if (found) {
                if (postingItem == null) {
                    postingItem = new PostingsEnumPhraseCompound.Item(null, null);
                }
                postingItem.compoundList = compoundList;
            }
            if (postingItem == null) {
                return null;
            }
            postList.add(postingItem);
        }
        if (!postList.isEmpty()) {
            PostingsEnumPhraseCompound mpost = new PostingsEnumPhraseCompound((List<PostingsEnumPhraseCompound.Item>)postList, context, field, this.isStrict);
            return new PostingsEnumData(mpost, null, matchCost);
        }
        return null;
    }

    private PostingsEnumData getPostingEnumStandard(ContextCache context, boolean needPayload) throws IOException {
        float matchCost = 0.0f;
        ArrayList<PostingsEnumPhraseStandard.Item> postList = new ArrayList<PostingsEnumPhraseStandard.Item>(this.weightList.length);
        String field = "";
        for (PSolWeightItem item : this.weightList) {
            PostingsEnumData subData = item.getPostingsEnum(context, needPayload);
            if (subData == null || subData.postings == null) {
                return null;
            }
            if (field.isEmpty()) {
                field = item.getSearchField();
            }
            postList.add(new PostingsEnumPhraseStandard.Item(subData.postings, subData.term));
            matchCost += subData.matchCost;
        }
        if (!postList.isEmpty()) {
            PostingsEnumPhraseStandard mpost = new PostingsEnumPhraseStandard((List<PostingsEnumPhraseStandard.Item>)postList, context, field, this.isStrict);
            return new PostingsEnumData(mpost, null, matchCost);
        }
        return null;
    }

    @Override
    public void extractTerms(Set<Term> queryTerms, Consumer<Query> queryConsumer) {
        for (PSolWeightItem item : this.weightList) {
            item.extractTerms(queryTerms, queryConsumer);
        }
    }

    @Override
    public void extractWeightedSpanTerms(LeafReaderContext context, String fieldName, Map<String, WeightedSpanTerm> terms, Consumer<Query> queryConsumer) throws IOException {
        ArrayList<PositionSpan> posList = new ArrayList<PositionSpan>();
        PostingsEnumData postingsdata = this.getPostingsEnum(new ContextCache(context), false);
        if (postingsdata != null) {
            while (postingsdata.postings.nextDoc() != Integer.MAX_VALUE) {
                for (int freqState = 0; freqState < postingsdata.postings.freq(); ++freqState) {
                    int pos = postingsdata.postings.nextPosition();
                    posList.add(new PositionSpan(pos, pos + this.weightList.length));
                }
            }
        }
        for (PSolWeightItem item : this.weightList) {
            HashMap<String, WeightedSpanTerm> subTerms = new HashMap<String, WeightedSpanTerm>();
            item.extractWeightedSpanTerms(context, fieldName, subTerms, queryConsumer);
            subTerms.forEach((text, subTerm) -> {
                WeightedSpanTerm weightedTerm = (WeightedSpanTerm)terms.get(text);
                if (weightedTerm != null) {
                    weightedTerm.addPositionSpans(posList);
                } else {
                    subTerm.setPositionSensitive(true);
                    subTerm.addPositionSpans(posList);
                    terms.put((String)text, (WeightedSpanTerm)subTerm);
                }
            });
        }
    }

    @Override
    public String getSearchField() {
        if (this.weightList.length > 0) {
            return this.weightList[0].getSearchField();
        }
        return "";
    }
}

