/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.queryparser.boost.PSolBoost;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumData;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;

public class PostingsEnumExact
extends PostingsEnumBase {
    private final PostingsEnumData childData;
    private final PostingsEnum child;
    private int pos;
    private int freq;
    private int freqState;
    private int doc;
    private FieldDefinitions.WordPart wordPart;
    private PositionState positionState = PositionState.noMorePositions;

    PostingsEnumExact(PostingsEnumData child, FieldDefinitions.WordPart wordPart) {
        this.childData = child;
        this.child = child.postings;
        this.pos = -1;
        this.wordPart = wordPart;
    }

    @Override
    public int docID() {
        return this.child.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        do {
            this.doc = this.child.nextDoc();
            if (this.doc == Integer.MAX_VALUE) {
                this.positionState = PositionState.noMorePositions;
                return this.doc;
            }
            this.positionState = PositionState.uninitialized;
        } while (!this.calculateNextPosition());
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        while (true) {
            this.doc = this.child.advance(target);
            if (this.doc == Integer.MAX_VALUE) {
                this.positionState = PositionState.noMorePositions;
                return this.doc;
            }
            this.positionState = PositionState.uninitialized;
            if (this.calculateNextPosition()) {
                return this.doc;
            }
            target = this.doc + 1;
        }
    }

    @Override
    public long cost() {
        return this.child.cost();
    }

    @Override
    public int freq() throws IOException {
        this.calculateNextPosition();
        return this.freq;
    }

    @Override
    public int nextPosition() throws IOException {
        if (this.calculateNextPosition()) {
            this.positionState = PositionState.uncalced;
            return this.pos;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int startOffset() throws IOException {
        return this.child.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.child.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.child.getPayload();
    }

    @Override
    public int getPhraseEnd() {
        if (this.child instanceof PostingsEnumBase) {
            return ((PostingsEnumBase)this.child).getPhraseEnd();
        }
        return super.getPhraseEnd();
    }

    @Override
    public boolean foundInCommonField() {
        if (this.child instanceof PostingsEnumBase) {
            return ((PostingsEnumBase)this.child).foundInCommonField();
        }
        return super.foundInCommonField();
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        Explanation expl = this.child instanceof PostingsEnumBase ? ((PostingsEnumBase)this.child).explain(context, doc) : (this.childData.term != null ? Explanation.match((Number)1, this.childData.term.toString(), new Explanation[0]) : null);
        return expl;
    }

    @Override
    public IntList getReferencedDocList() {
        if (this.child instanceof PostingsEnumBase) {
            return ((PostingsEnumBase)this.child).getReferencedDocList();
        }
        return super.getReferencedDocList();
    }

    private boolean calculateNextPosition() throws IOException {
        if (this.positionState == PositionState.uninitialized) {
            this.freq = 0;
            this.freqState = 0;
            this.pos = -1;
            this.positionState = PositionState.uncalced;
        }
        if (this.positionState == PositionState.uncalced) {
            if (this.advanceToNextPosition()) {
                this.positionState = PositionState.calced;
                ++this.freq;
                return true;
            }
            this.positionState = PositionState.noMorePositions;
        } else if (this.positionState == PositionState.calced) {
            return true;
        }
        return false;
    }

    private boolean advanceToNextPosition() throws IOException {
        while (this.freqState < this.child.freq()) {
            ++this.freqState;
            this.pos = this.child.nextPosition();
            boolean isExact = PSolBoost.isOnExactMatchPosition(this.pos) && !PSolBoost.isStemmedToken(this.child) && this.matchWordPart(this.wordPart);
            if (!isExact) continue;
            return true;
        }
        return false;
    }

    private static enum PositionState {
        uninitialized,
        uncalced,
        calced,
        noMorePositions;

    }
}

