/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumBase;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumDisjunct;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;

public class PostingsEnumOpt
extends PostingsEnumBase {
    protected PostingsEnumDisjunct leadItem;
    protected PostingsEnumDisjunct optItem;
    protected PostingsEnumDisjunct scoreItem;
    protected float optBoost;
    protected int doc;

    PostingsEnumOpt(PostingsEnumDisjunct leadItem, PostingsEnumDisjunct optItem, PostingsEnumDisjunct scoreItem, float optBoost) {
        this.leadItem = leadItem;
        this.optItem = optItem;
        this.scoreItem = scoreItem;
        this.optBoost = optBoost;
        this.doc = -1;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int nextDoc() throws IOException {
        this.doc = this.leadItem.nextDoc();
        if (this.doc != Integer.MAX_VALUE) {
            this.optItem.advance(this.doc);
        }
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        this.doc = this.leadItem.advance(target);
        if (this.doc != Integer.MAX_VALUE) {
            this.optItem.advance(this.doc);
        }
        return this.doc;
    }

    @Override
    public long cost() {
        return this.leadItem.cost() + this.optItem.cost();
    }

    @Override
    public int freq() throws IOException {
        if (this.scoreItem.docID() == this.doc) {
            return this.scoreItem.freq();
        }
        return 0;
    }

    @Override
    public int nextPosition() throws IOException {
        return this.scoreItem.nextPosition();
    }

    @Override
    public int startOffset() throws IOException {
        if (this.scoreItem.docID() == this.doc) {
            return this.scoreItem.startOffset();
        }
        return -1;
    }

    @Override
    public int endOffset() throws IOException {
        if (this.scoreItem.docID() == this.doc) {
            return this.scoreItem.endOffset();
        }
        return -1;
    }

    @Override
    public BytesRef getPayload() throws IOException {
        if (this.scoreItem.docID() == this.doc) {
            return this.scoreItem.getPayload();
        }
        return null;
    }

    @Override
    public int getPhraseEnd() {
        if (this.scoreItem.docID() == this.doc) {
            return this.scoreItem.getPhraseEnd();
        }
        return -1;
    }

    @Override
    public boolean foundInCommonField() {
        if (this.scoreItem.docID() == this.doc) {
            return this.scoreItem.foundInCommonField();
        }
        return false;
    }

    @Override
    public float getBoost() {
        float boost = 0.0f;
        if (this.scoreItem.docID() == this.doc) {
            boost += this.scoreItem.getBoost();
        }
        if (this.optItem.docID() == this.doc) {
            boost += this.optBoost;
        }
        return boost;
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) {
        Explanation expl = null;
        if (this.scoreItem.docID() == doc) {
            expl = this.scoreItem.explain(context, doc);
        }
        if (this.optItem.docID() == doc) {
            Explanation explOpt = Explanation.match((Number)Float.valueOf(this.optBoost), "exact term was found", new Explanation[0]);
            expl = Explanation.match((Number)Float.valueOf(this.getBoost()), "sum of:", explOpt, expl);
        }
        return expl;
    }

    @Override
    public IntList getReferencedDocList() {
        if (this.scoreItem != null) {
            return this.scoreItem.getReferencedDocList();
        }
        return null;
    }

    public boolean optMatches() {
        return this.optItem.docID() == this.doc;
    }

    public float getOptBoost() {
        return this.optBoost;
    }
}

