/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.queryparser.psolquery;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.ContextCache;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PostingsEnumPhrase;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;

public class PostingsEnumPhraseCompound
extends PostingsEnumPhrase {
    PostingsEnumPhraseCompound(List<Item> list, ContextCache contextCache, String searchField, boolean isStrict) {
        super(list, contextCache, searchField, isStrict);
        this.iterator = this.createApproximation(list);
    }

    private DocIdSetIterator createApproximation(List<Item> itemList) {
        if (itemList.size() == 1) {
            return itemList.get(0).createApproximation();
        }
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (Item item : itemList) {
            iterators.add(item.createApproximation());
        }
        return ConjunctionUtils.intersectIterators(iterators);
    }

    @Override
    protected boolean advanceToNextPosition() throws IOException {
        block5: {
            Item lead = (Item)this.getItem(0);
            PostingsEnumPhrase.Item.State lstate = lead.nextPosition();
            if (lstate != PostingsEnumPhrase.Item.State.Found) {
                return false;
            }
            int lastMatchEnd = lead.matchEnd;
            int icount = this.countItems();
            while (true) {
                for (int j = 1; j < icount; ++j) {
                    Item item = (Item)this.getItem(j);
                    PostingsEnumPhrase.Item.State state = item.advancePosition(lastMatchEnd);
                    if (state == PostingsEnumPhrase.Item.State.Finished) break block5;
                    if (state == PostingsEnumPhrase.Item.State.NotFound) {
                        lstate = lead.nextPosition();
                        if (lstate == PostingsEnumPhrase.Item.State.Found) {
                            lastMatchEnd = lead.matchEnd;
                            continue;
                        }
                        break block5;
                    }
                    lastMatchEnd = item.matchEnd;
                }
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkPhraseMatchesStrictMode(int doc) {
        int icount = this.countItems();
        for (int i = 0; i < icount; ++i) {
            int matchEnd;
            int matchBgn = this.getItem(i).getMatchBgn();
            if (matchBgn == (matchEnd = this.getItem(i).getMatchEnd()) && matchBgn % 100 == 0) continue;
            return false;
        }
        int firstPos = this.getItem(0).getMatchBgn();
        int lastPos = this.getItem(this.countItems() - 1).getMatchEnd();
        IntSet termsByDoc = this.getPositionsByDocId(doc);
        if (termsByDoc != null) {
            IntIterator intIterator = termsByDoc.iterator();
            while (intIterator.hasNext()) {
                int pos = (Integer)intIterator.next();
                if (pos == firstPos - 100) {
                    return false;
                }
                if (pos != lastPos + 100) continue;
                return false;
            }
        }
        return true;
    }

    public static class Item
    extends PostingsEnumPhrase.Item {
        public List<Item> compoundList;
        public int compoundBgn = -1;
        public int compoundEnd = -1;
        public int matchBgn = -1;
        public int matchEnd = -1;
        public boolean matchPostings = false;
        public boolean matchCompound = false;

        public Item(PostingsEnum postings, Term term) {
            super(postings, term);
        }

        private DocIdSetIterator getApproximationForCompoundList() {
            if (this.compoundList.size() == 1) {
                return this.compoundList.get((int)0).postings;
            }
            ArrayList<PostingsEnum> iterators = new ArrayList<PostingsEnum>();
            for (Item item : this.compoundList) {
                iterators.add(item.postings);
            }
            return ConjunctionUtils.intersectIterators(iterators);
        }

        @Override
        public DocIdSetIterator createApproximation() {
            if (this.compoundList == null) {
                return this.postings;
            }
            if (this.postings == null) {
                return this.getApproximationForCompoundList();
            }
            return new AlternateDocIdSetIterator(this.postings, this.getApproximationForCompoundList());
        }

        @Override
        public void resetPosition(int docID) throws IOException {
            this.freqState = 0;
            this.postPos = -1;
            this.compoundBgn = -1;
            this.compoundEnd = -1;
            this.matchBgn = -1;
            this.matchEnd = -1;
            boolean bl = this.matchPostings = this.postings != null && this.postings.docID() == docID;
            if (this.compoundList != null) {
                this.matchCompound = true;
                for (Item compoundItem : this.compoundList) {
                    if (compoundItem.postings.docID() != docID) {
                        this.matchCompound = false;
                        break;
                    }
                    compoundItem.freqState = 0;
                    compoundItem.postPos = -1;
                }
            } else {
                this.matchCompound = false;
            }
        }

        @Override
        public PostingsEnumPhrase.Item.State nextPosition() throws IOException {
            int postPosition = Integer.MAX_VALUE;
            if (this.matchPostings && this.freqState < this.postings.freq()) {
                postPosition = this.postPos;
            }
            int compoundPosition = Integer.MAX_VALUE;
            if (this.matchCompound) {
                compoundPosition = this.compoundBgn;
            }
            if (postPosition == Integer.MAX_VALUE && compoundPosition == Integer.MAX_VALUE) {
                return PostingsEnumPhrase.Item.State.Finished;
            }
            if (compoundPosition == postPosition || compoundPosition == postPosition + 1) {
                this.postPos = this.postings.nextPosition();
                ++this.freqState;
                if (this.advanceCompoundToNextPosition() == PostingsEnumPhrase.Item.State.Finished) {
                    this.compoundBgn = Integer.MAX_VALUE;
                }
            } else if (postPosition < compoundPosition) {
                this.postPos = this.postings.nextPosition();
                ++this.freqState;
            } else if (this.advanceCompoundToNextPosition() == PostingsEnumPhrase.Item.State.Finished) {
                this.compoundBgn = Integer.MAX_VALUE;
            }
            if (this.postPos != -1 && (this.compoundBgn == -1 || this.postPos < this.compoundBgn)) {
                this.matchBgn = this.postPos;
                this.matchEnd = this.postPos;
                return PostingsEnumPhrase.Item.State.Found;
            }
            if (this.compoundBgn != -1 && this.compoundBgn != Integer.MAX_VALUE) {
                this.matchBgn = this.compoundBgn;
                this.matchEnd = this.compoundEnd;
                return PostingsEnumPhrase.Item.State.Found;
            }
            return PostingsEnumPhrase.Item.State.NotFound;
        }

        @Override
        public PostingsEnumPhrase.Item.State advancePosition(int currentPos) throws IOException {
            int expectedPos3;
            int expectedPos2;
            int expectedPos1;
            boolean endOfBlock;
            boolean bl = endOfBlock = currentPos % 2 == 0;
            if (endOfBlock) {
                expectedPos1 = currentPos + (100 - currentPos % 100);
                expectedPos2 = expectedPos1 + 1;
                expectedPos3 = expectedPos1 + 2;
            } else {
                expectedPos1 = currentPos + 2;
                expectedPos2 = -2;
                expectedPos3 = currentPos + 3;
            }
            if (this.matchPostings) {
                if (!Item.advancePosition(this, expectedPos1)) {
                    this.postPos = Integer.MAX_VALUE;
                } else if (this.postPos == expectedPos1 || this.postPos == expectedPos2 || this.postPos == expectedPos3) {
                    this.matchBgn = this.postPos;
                    this.matchEnd = this.postPos;
                    return PostingsEnumPhrase.Item.State.Found;
                }
            }
            if (this.matchCompound) {
                PostingsEnumPhrase.Item.State state = this.advanceCompoundToPosition(expectedPos1, expectedPos2, expectedPos3);
                if (state == PostingsEnumPhrase.Item.State.Found) {
                    this.matchBgn = this.compoundBgn;
                    this.matchEnd = this.compoundEnd;
                    return state;
                }
                if (state == PostingsEnumPhrase.Item.State.Finished && this.postPos == Integer.MAX_VALUE) {
                    return PostingsEnumPhrase.Item.State.Finished;
                }
            }
            return PostingsEnumPhrase.Item.State.NotFound;
        }

        private PostingsEnumPhrase.Item.State advanceCompoundToNextPosition() throws IOException {
            int phrasePos;
            boolean leadEndOfBlock;
            Item lead = this.compoundList.get(0);
            if (lead.freqState < lead.postings.freq()) {
                lead.postPos = lead.postings.nextPosition();
                ++lead.freqState;
            } else {
                return PostingsEnumPhrase.Item.State.Finished;
            }
            boolean endOfBlock = leadEndOfBlock = lead.postPos % 2 == 0;
            block0: while (true) {
                phrasePos = lead.postPos;
                for (int j = 1; j < this.compoundList.size(); ++j) {
                    int expectedPos3;
                    int expectedPos2;
                    int expectedPos1;
                    Item item = this.compoundList.get(j);
                    if (endOfBlock) {
                        expectedPos1 = phrasePos + (100 - phrasePos % 100);
                        expectedPos2 = expectedPos1 + 1;
                        expectedPos3 = expectedPos1 + 2;
                    } else {
                        expectedPos1 = phrasePos + 2;
                        expectedPos2 = -2;
                        expectedPos3 = phrasePos + 3;
                    }
                    if (!Item.advancePosition(item, expectedPos1)) {
                        return PostingsEnumPhrase.Item.State.Finished;
                    }
                    if (item.postPos != expectedPos1 && item.postPos != expectedPos2 && item.postPos != expectedPos3) {
                        int nextLeadPos;
                        int n = nextLeadPos = leadEndOfBlock ? lead.postPos + (100 - lead.postPos % 100) : lead.postPos + 2;
                        if (Item.advancePosition(lead, nextLeadPos)) continue block0;
                        return PostingsEnumPhrase.Item.State.Finished;
                    }
                    phrasePos = item.postPos;
                    endOfBlock = phrasePos % 2 == 0;
                }
                break;
            }
            this.compoundBgn = lead.postPos;
            this.compoundEnd = phrasePos;
            return PostingsEnumPhrase.Item.State.Found;
        }

        private PostingsEnumPhrase.Item.State advanceCompoundToPosition(int expectedPos1, int expectedPos2, int expectedPos3) throws IOException {
            Item lead = this.compoundList.get(0);
            if (!Item.advancePosition(lead, expectedPos1)) {
                return PostingsEnumPhrase.Item.State.Finished;
            }
            if (lead.postPos != expectedPos1 && lead.postPos != expectedPos2 && lead.postPos != expectedPos3) {
                return PostingsEnumPhrase.Item.State.NotFound;
            }
            boolean endOfBlock = lead.postPos % 2 == 0;
            int phrasePos = lead.postPos;
            for (int j = 1; j < this.compoundList.size(); ++j) {
                Item item = this.compoundList.get(j);
                if (endOfBlock) {
                    expectedPos1 = phrasePos + (100 - phrasePos % 100);
                    expectedPos2 = expectedPos1 + 1;
                    expectedPos3 = expectedPos1 + 2;
                } else {
                    expectedPos1 = phrasePos + 2;
                    expectedPos2 = -2;
                    expectedPos3 = phrasePos + 3;
                }
                if (!Item.advancePosition(item, expectedPos1)) {
                    return PostingsEnumPhrase.Item.State.Finished;
                }
                if (item.postPos != expectedPos1 && item.postPos != expectedPos2 && item.postPos != expectedPos3) {
                    return PostingsEnumPhrase.Item.State.NotFound;
                }
                endOfBlock = item.postPos % 2 == 0;
            }
            return PostingsEnumPhrase.Item.State.Found;
        }

        private static boolean advancePosition(Item item, int target) throws IOException {
            while (item.postPos < target) {
                if (item.freqState == item.postings.freq()) {
                    return false;
                }
                item.postPos = item.postings.nextPosition();
                ++item.freqState;
            }
            return true;
        }

        @Override
        public int getMatchBgn() {
            return this.matchBgn;
        }

        @Override
        public int getMatchEnd() {
            return this.matchEnd;
        }

        @Override
        public float getBoost() {
            if (this.matchCompound && this.matchBgn == this.compoundBgn) {
                float score = 0.0f;
                for (Item item : this.compoundList) {
                    score += item.getBoost();
                }
                return score /= (float)this.compoundList.size();
            }
            return super.getBoost();
        }

        @Override
        public void getExplain(List<Explanation> subs, LeafReaderContext context, int doc) {
            if (this.matchCompound && this.matchBgn == this.compoundBgn) {
                for (Item item : this.compoundList) {
                    item.getExplain(subs, context, doc);
                }
            } else {
                super.getExplain(subs, context, doc);
            }
        }
    }

    public static class AlternateDocIdSetIterator
    extends DocIdSetIterator {
        private int doc;
        private DocIdSetIterator lead;
        private DocIdSetIterator other;

        AlternateDocIdSetIterator(DocIdSetIterator lead, DocIdSetIterator other) {
            this.lead = lead;
            this.other = other;
            this.doc = -1;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            long c = 0L;
            if (this.lead != null) {
                c += this.lead.cost();
            }
            if (this.other != null) {
                c += this.other.cost();
            }
            return c;
        }

        @Override
        public int nextDoc() throws IOException {
            while (this.lead != null && this.lead.docID() != Integer.MAX_VALUE && this.lead.docID() <= this.doc) {
                this.lead.nextDoc();
            }
            while (this.other != null && this.other.docID() != Integer.MAX_VALUE && this.other.docID() <= this.doc) {
                this.other.nextDoc();
            }
            this.doc = this.lead == null ? this.other.docID() : (this.other == null ? this.lead.docID() : (this.lead.docID() < this.other.docID() ? this.lead.docID() : this.other.docID()));
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.lead != null && this.lead.docID() < target) {
                this.lead.advance(target);
            }
            if (this.other != null && this.other.docID() < target) {
                this.other.advance(target);
            }
            this.doc = this.lead == null ? this.other.docID() : (this.other == null ? this.lead.docID() : (this.lead.docID() < this.other.docID() ? this.lead.docID() : this.other.docID()));
            return this.doc;
        }
    }
}

