/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.related;

import de.cadenas.catalogsearch.lucene.related.RelatedIndexerData.CreateRelatedWordData;
import de.cadenas.catalogsearch.lucene.related.RelatedIndexerData.RelatedIndexerRequestData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RelatedDataRequest {
    public List<RelatedWord> words = null;
    public String language;

    public static RelatedDataRequest fromBinary(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        RelatedIndexerRequestData rd = RelatedIndexerRequestData.getRootAsRelatedIndexerRequestData(buffer);
        RelatedDataRequest pd = new RelatedDataRequest();
        pd.language = rd.language();
        pd.words = new ArrayList<RelatedWord>();
        int wordLength = rd.wordsLength();
        for (int w = 0; w < wordLength; ++w) {
            CreateRelatedWordData rw = rd.words(w);
            RelatedWord word = new RelatedWord();
            word.nearWord = rw.nearWord();
            word.srcWord = rw.srcWord();
            word.count = rw.count();
            pd.words.add(word);
        }
        return pd;
    }

    public static class RelatedWord {
        String nearWord;
        String srcWord;
        int count = 0;
    }
}

