/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.related;

import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.fields.PSolTextField;
import de.cadenas.catalogsearch.lucene.index.CatalogIndexer;
import de.cadenas.catalogsearch.lucene.related.RelatedDataRequest;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.FSDirectory;

public class RelatedIndexer {
    private static PLogger logger = new PLogger(CatalogIndexer.class.getSimpleName());
    private final Path _indexPath;
    private final IndexWriterConfig.OpenMode _openMode;
    private IndexWriter _indexWriter;

    public RelatedIndexer(String absolutePath, IndexWriterConfig.OpenMode openMode) throws Exception {
        this._indexPath = Paths.get(absolutePath, new String[0]);
        this._openMode = openMode;
        this.init();
    }

    public void commit() throws Exception {
        this._indexWriter.commit();
    }

    public synchronized void close() throws Exception {
        if (this._indexWriter.isOpen()) {
            this._indexWriter.forceMerge(1, true);
        }
        this._indexWriter.close();
    }

    private void init() throws Exception {
        FSDirectory directory = FSDirectory.open(this._indexPath);
        FieldAwareAnalyzer analyzer = new FieldAwareAnalyzer(true);
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        config.setOpenMode(this._openMode);
        config.setMergeScheduler(new SerialMergeScheduler());
        config.setUseCompoundFile(false);
        config.setRAMBufferSizeMB(48.0);
        this._indexWriter = new IndexWriter(directory, config);
    }

    public synchronized void addWords(String language, List<RelatedDataRequest.RelatedWord> words) {
        for (RelatedDataRequest.RelatedWord word : words) {
            Document doc = this.createDocument(language, word.nearWord, word.srcWord, word.count);
            try {
                this._indexWriter.addDocument(doc);
            }
            catch (IOException ex) {
                logger.error("Error adding documents to related words index");
            }
        }
    }

    private Document createDocument(String language, String nearWord, String srcWord, int count) {
        Document doc = new Document();
        StoredField f = new StoredField("nearWord", nearWord);
        doc.add(f);
        StringField langField = new StringField("language", language, Field.Store.YES);
        doc.add(langField);
        doc.add(new StoredField("count", count));
        StoredField srcField = new StoredField("srcWord", srcWord);
        doc.add(srcField);
        PSolTextField dataField = new PSolTextField("data_" + language + "_lang", srcWord, Field.Store.NO);
        doc.add(dataField);
        return doc;
    }
}

