/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.related;

import de.cadenas.catalogsearch.lucene.analysis.FieldAwareAnalyzer;
import de.cadenas.catalogsearch.lucene.queryparser.QueryParser;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQuery;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolQueryItem;
import de.cadenas.catalogsearch.lucene.related.RelatedWord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;

public class RelatedWords {
    static final String F_NEARWORD = "nearWord";
    static final String F_COUNT = "count";
    static final String F_SRCWORD = "srcWord";
    static final String F_LANGUAGE = "language";
    static final String F_DATA = "data";

    public List<RelatedWord> findRelatedWords(IndexSearcher indexSearcher, List<String> wordList, List<String> languageList, int maxResults) throws IOException {
        ArrayList<RelatedWord> resultList = new ArrayList<RelatedWord>();
        HashMap<RelatedWord, RelatedWord> map = new HashMap<RelatedWord, RelatedWord>();
        String initialLanguage = languageList.get(0);
        boolean initial = true;
        QueryParser parser = new QueryParser(new FieldAwareAnalyzer(false));
        for (String word : wordList) {
            ScoreDoc[] hits;
            Query query;
            if (!initial) {
                map.forEach((k, v) -> {
                    k.valid = false;
                });
            }
            if (languageList.size() == 1) {
                query = this.buildLanguageQuery(parser, languageList.get(0), word);
            } else {
                BooleanQuery.Builder q = new BooleanQuery.Builder();
                for (String language : languageList) {
                    Query subQuery = this.buildLanguageQuery(parser, language, word);
                    if (subQuery == null) continue;
                    q.add(new BooleanClause(subQuery, BooleanClause.Occur.SHOULD));
                }
                query = q.build();
            }
            int maxHits = 10 * maxResults;
            for (ScoreDoc hit : hits = indexSearcher.search((Query)query, (int)maxHits).scoreDocs) {
                Document doc = indexSearcher.doc(hit.doc);
                String nearWord = doc.get(F_NEARWORD);
                if (nearWord.equalsIgnoreCase(word)) continue;
                RelatedWord relWord = new RelatedWord();
                relWord.word = nearWord;
                relWord.language = doc.get(F_LANGUAGE);
                relWord.count = doc.getField(F_COUNT).numericValue().intValue();
                relWord.valid = true;
                RelatedWord found = (RelatedWord)map.get(relWord);
                if (found != null) {
                    if (initial) {
                        found.count += relWord.count;
                    }
                    found.valid = true;
                    continue;
                }
                map.put(relWord, relWord);
            }
            initial = false;
        }
        if (map.isEmpty()) {
            return resultList;
        }
        PriorityQueue queue = new PriorityQueue(map.size(), (s1, s2) -> s2.count - s1.count);
        map.forEach((k, v) -> {
            if (v.valid && v.language.equals(initialLanguage)) {
                queue.add(v);
            }
        });
        while (!queue.isEmpty() && resultList.size() < maxResults) {
            resultList.add((RelatedWord)queue.remove());
        }
        if (resultList.isEmpty()) {
            queue.clear();
            map.forEach((k, v) -> {
                if (v.valid && !v.language.equals(initialLanguage)) {
                    queue.add(v);
                }
            });
            for (RelatedWord w : queue) {
                resultList.add(w);
                if (resultList.size() < maxResults) continue;
                break;
            }
        }
        return resultList;
    }

    private Query buildLanguageQuery(QueryParser parser, String language, String word) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        String fieldName = "data_" + language + "_lang";
        PSolQueryItem queryItem = parser.createFieldSubQuery(fieldName, word, false, language.equalsIgnoreCase("german"), false);
        if (queryItem == null) {
            return null;
        }
        PSolQuery psQuery = new PSolQuery(queryItem);
        query.add(new BooleanClause(psQuery, BooleanClause.Occur.MUST));
        query.add(new BooleanClause(new TermQuery(new Term(F_LANGUAGE, language)), BooleanClause.Occur.MUST));
        return query.build();
    }
}

