/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.IIndexManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class CatalogBoostQuery
extends Query {
    private final Query child;
    private IIndexManager.BoostRange[] rangeList;
    private IIndexManager.BoostRange searchKey;

    public CatalogBoostQuery(Query child, IIndexManager.BoostRange[] rangeList) {
        this.child = child;
        this.rangeList = rangeList;
        this.searchKey = new IIndexManager.BoostRange();
    }

    public Query getQuery() {
        return this.child;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.child.visit(visitor);
    }

    @Override
    public String toString(String field) {
        return this.child.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogBoostQuery other = (CatalogBoostQuery)obj;
        if (this.child == null) {
            return other.child == null;
        }
        return this.child.equals(other.child);
    }

    @Override
    public int hashCode() {
        return this.child.hashCode();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newchild = this.child.rewrite(reader);
        if (newchild != this.child) {
            return new CatalogBoostQuery(newchild, this.rangeList);
        }
        return this;
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){
            Weight childWeight;
            {
                super(query);
                this.childWeight = CatalogBoostQuery.this.child.createWeight(searcher, scoreMode, boost);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                return this.childWeight.matches(context, doc);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation expl = this.childWeight.explain(context, doc);
                float boost2 = this.getBoostFactor(doc);
                if (boost2 != 1.0f) {
                    expl = Explanation.match((Number)Float.valueOf(boost2 * expl.getValue().floatValue()), "catalog boost: " + expl.getValue().toString() + " * " + Float.toString(boost2), expl);
                }
                return expl;
            }

            private float getBoostFactor(int docID) {
                CatalogBoostQuery.this.searchKey.low = docID;
                int index = Arrays.binarySearch(CatalogBoostQuery.this.rangeList, CatalogBoostQuery.this.searchKey);
                if (index < 0) {
                    index = -2 - index;
                }
                if (index >= 0 && index < CatalogBoostQuery.this.rangeList.length) {
                    IIndexManager.BoostRange r = CatalogBoostQuery.this.rangeList[index];
                    if (docID >= r.low && docID < r.up) {
                        return r.boost;
                    }
                }
                return 1.0f;
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final Scorer childScorer = this.childWeight.scorer(context);
                if (childScorer == null) {
                    return null;
                }
                return new Scorer(this){

                    @Override
                    public float score() throws IOException {
                        float s = childScorer.score();
                        int docID = childScorer.docID();
                        return s * this.getBoostFactor(docID);
                    }

                    @Override
                    public int docID() {
                        return childScorer.docID();
                    }

                    @Override
                    public void setMinCompetitiveScore(float minScore) throws IOException {
                        childScorer.setMinCompetitiveScore(minScore);
                    }

                    @Override
                    public Collection<Scorable.ChildScorable> getChildren() throws IOException {
                        return childScorer.getChildren();
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return childScorer.iterator();
                    }

                    @Override
                    public TwoPhaseIterator twoPhaseIterator() {
                        return childScorer.twoPhaseIterator();
                    }

                    @Override
                    public int advanceShallow(int target) throws IOException {
                        return childScorer.advanceShallow(target);
                    }

                    @Override
                    public float getMaxScore(int upTo) throws IOException {
                        return childScorer.getMaxScore(upTo);
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                return this.childWeight.scorerSupplier(context);
            }
        };
    }
}

