/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolScorer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class DocumentResolveCollector
implements Collector,
LeafCollector {
    private Scorable scorer = null;
    private final Int2ObjectMap<IntList> referencedDocs = new Int2ObjectOpenHashMap<IntList>();
    private int docBase = 0;
    private List<PSolScorer> childScorer = null;

    protected void mergeReferencedDocs(Int2ObjectMap<IntList> docs) {
        for (Int2ObjectMap.Entry entry : docs.int2ObjectEntrySet()) {
            this.referencedDocs.put(entry.getIntKey(), (IntList)entry.getValue());
        }
    }

    public Int2ObjectMap<IntList> getReferencedDocs() {
        return this.referencedDocs;
    }

    private void collectChildScorer(Scorable scorer) {
        if (scorer instanceof PSolScorer) {
            this.childScorer.add((PSolScorer)scorer);
        } else {
            try {
                Collection<Scorable.ChildScorable> subScorer = scorer.getChildren();
                for (Scorable.ChildScorable sc : subScorer) {
                    this.collectChildScorer(sc.child);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) {
        this.docBase = context.docBase;
        return this;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.TOP_SCORES;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
        this.childScorer = null;
    }

    @Override
    public void collect(int doc) {
        if (this.scorer != null) {
            if (this.childScorer == null) {
                this.childScorer = new ArrayList<PSolScorer>();
                this.collectChildScorer(this.scorer);
            }
            for (PSolScorer ps : this.childScorer) {
                IntList referencedDocs = ps.getReferencedDocList();
                if (referencedDocs == null) continue;
                for (int i = 0; i < referencedDocs.size(); ++i) {
                    referencedDocs.set(i, referencedDocs.get(i) + this.docBase);
                }
                this.referencedDocs.put(doc + this.docBase, referencedDocs);
            }
        }
    }
}

