/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.lucene.search.SearchResultFilter;
import de.cadenas.util.PIntPair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class FilteringCollectorManager
implements CollectorManager<FilteringCollector, Object[]> {
    private final CollectorManager<Collector, ?>[] collectorManagers;
    private SearchResultFilter filter;
    private Map<String, List<String>> excludedProjects;

    @SafeVarargs
    public FilteringCollectorManager(CollectorManager<? extends Collector, ?> ... collectorManagers) {
        this.collectorManagers = collectorManagers;
    }

    public void setSearchResultFilter(SearchResultFilter filter, Map<String, List<String>> excludedProjects) {
        this.filter = filter;
        this.excludedProjects = excludedProjects;
    }

    @Override
    public FilteringCollector newCollector() throws IOException {
        return new FilteringCollector();
    }

    @Override
    public Object[] reduce(Collection<FilteringCollector> reducibleCollectors) throws IOException {
        int size = reducibleCollectors.size();
        Object[] results = new Object[this.collectorManagers.length];
        for (int i = 0; i < this.collectorManagers.length; ++i) {
            ArrayList<Collector> reducibleCollector = new ArrayList<Collector>(size);
            for (FilteringCollector collectors : reducibleCollectors) {
                reducibleCollector.add(collectors.collectors[i]);
            }
            results[i] = this.collectorManagers[i].reduce(reducibleCollector);
        }
        return results;
    }

    public class FilteringCollector
    implements Collector,
    LeafCollector {
        private LeafCollector[] leafCollectors;
        private final Collector[] collectors;
        private IntSet leafFilter = null;
        private IntSet excludeFilter = null;
        private int baseDocId = 0;
        private final IIndexManager indexManager;

        private void createLeafCollectors(LeafReaderContext context) throws IOException {
            this.leafCollectors = new LeafCollector[this.collectors.length];
            for (int i = 0; i < this.collectors.length; ++i) {
                this.leafCollectors[i] = this.collectors[i].getLeafCollector(context);
            }
        }

        public FilteringCollector() throws IOException {
            this.collectors = new Collector[FilteringCollectorManager.this.collectorManagers.length];
            for (int i = 0; i < this.collectors.length; ++i) {
                this.collectors[i] = FilteringCollectorManager.this.collectorManagers[i].newCollector();
            }
            this.indexManager = ServiceFactory.getIndexManager();
        }

        @Override
        public final LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.leafFilter = null;
            this.excludeFilter = null;
            this.baseDocId = 0;
            if (FilteringCollectorManager.this.filter != null || FilteringCollectorManager.this.excludedProjects != null) {
                CompositeReader reader = context.parent.reader();
                IIndexManager.IIndexReaderData indexContainer = this.indexManager.findReaderData(reader);
                if (indexContainer != null) {
                    Set<String> usedCatalogs = indexContainer.getUsedCatalogNames();
                    for (String catName : usedCatalogs) {
                        List<String> pathList;
                        IntSet catFilter;
                        Map<String, List<PIntPair>> catalogFilter;
                        IDocIdIndex docIdIndex = indexContainer.getDocIdIndex();
                        if (docIdIndex == null) continue;
                        if (FilteringCollectorManager.this.filter != null && (catalogFilter = FilteringCollectorManager.this.filter.getCatalogFilter(catName)) != null && !catalogFilter.isEmpty() && (catFilter = docIdIndex.createDocIdFilter(catalogFilter)) != null && !catFilter.isEmpty()) {
                            if (this.leafFilter == null) {
                                this.leafFilter = catFilter;
                            } else {
                                this.leafFilter.addAll(catFilter);
                            }
                        }
                        if (FilteringCollectorManager.this.excludedProjects != null && (pathList = FilteringCollectorManager.this.excludedProjects.get(catName)) != null && !pathList.isEmpty()) {
                            if (this.excludeFilter == null) {
                                this.excludeFilter = new IntOpenHashSet();
                            }
                            for (String path : pathList) {
                                docIdIndex.collectDocIds(path, this.excludeFilter);
                            }
                        }
                        if (this.leafFilter == null && this.excludeFilter == null) continue;
                        this.createLeafCollectors(context);
                        this.baseDocId = context.docBaseInParent;
                        return this;
                    }
                }
            } else {
                this.createLeafCollectors(context);
                return this;
            }
            return new IgnoringCollector();
        }

        @Override
        public final ScoreMode scoreMode() {
            ScoreMode scoreMode = null;
            for (Collector collector : this.collectors) {
                if (scoreMode == null) {
                    scoreMode = collector.scoreMode();
                    continue;
                }
                if (scoreMode == collector.scoreMode()) continue;
                return ScoreMode.COMPLETE;
            }
            return scoreMode;
        }

        @Override
        public final void setScorer(Scorable scorer) throws IOException {
            for (LeafCollector leafCollector : this.leafCollectors) {
                leafCollector.setScorer(scorer);
            }
        }

        @Override
        public final void collect(int doc) throws IOException {
            int catDocId = doc + this.baseDocId;
            if (this.excludeFilter != null && this.excludeFilter.contains(catDocId)) {
                return;
            }
            if (this.leafFilter != null && !this.leafFilter.contains(catDocId)) {
                return;
            }
            for (LeafCollector leafCollector : this.leafCollectors) {
                leafCollector.collect(doc);
            }
        }

        private class IgnoringCollector
        implements LeafCollector {
            private IgnoringCollector() {
            }

            @Override
            public void setScorer(Scorable scorer) {
            }

            @Override
            public void collect(int doc) {
            }
        }
    }
}

