/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ThreadInterruptedException;

public class PSolIndexSearcher
extends IndexSearcher {
    private IndexSearcher.LeafSlice[] leafSlices;

    public PSolIndexSearcher(IndexReaderContext context, ExecutorService executorService) {
        super(context, (Executor)executorService);
    }

    @Override
    protected IndexSearcher.LeafSlice[] slices(List<LeafReaderContext> leaves) {
        IndexSearcher.LeafSlice[] slices = new IndexSearcher.LeafSlice[leaves.size()];
        for (int i = 0; i < slices.length; ++i) {
            slices[i] = new IndexSearcher.LeafSlice(Collections.singletonList(leaves.get(i)));
        }
        this.leafSlices = slices;
        return this.leafSlices;
    }

    @Override
    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        Executor executor = this.getExecutor();
        if (executor == null || this.leafSlices.length <= 1) {
            Object collector = collectorManager.newCollector();
            this.search(query, (Collector)collector);
            return collectorManager.reduce(Collections.singletonList(collector));
        }
        ArrayList collectors = new ArrayList(this.leafSlices.length);
        ScoreMode scoreMode = null;
        for (int i = 0; i < this.leafSlices.length; ++i) {
            Object collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        if (scoreMode == null) {
            scoreMode = ScoreMode.COMPLETE;
        }
        query = this.rewrite(query);
        Weight weight = this.createWeight(query, scoreMode, 1.0f);
        ArrayList<Future<Collector>> topDocsFutures = new ArrayList<Future<Collector>>(this.leafSlices.length);
        for (int i = 0; i < this.leafSlices.length - 1; ++i) {
            LeafReaderContext[] leaves = this.leafSlices[i].leaves;
            if (leaves.length <= 0) continue;
            Collector collector = (Collector)collectors.get(i);
            FutureTask<Collector> futureTask = new FutureTask<Collector>(() -> {
                this.search(Arrays.asList(leaves), weight, collector);
                return collector;
            });
            executor.execute(futureTask);
            topDocsFutures.add(futureTask);
        }
        LeafReaderContext[] leaves = this.leafSlices[this.leafSlices.length - 1].leaves;
        Collector collector = (Collector)collectors.get(this.leafSlices.length - 1);
        this.search(Arrays.asList(leaves), weight, collector);
        topDocsFutures.add(CompletableFuture.completedFuture(collector));
        for (Future future : topDocsFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return collectorManager.reduce(collectors);
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        Query query = original;
        IndexReader reader = this.getIndexReader();
        Query rewrittenQuery = query.rewrite(reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(reader);
        }
        return query;
    }
}

