/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.IDocIdIndex;
import de.cadenas.catalogsearch.api.IIndexManager;
import de.cadenas.catalogsearch.api.ITreePathIndex;
import de.cadenas.catalogsearch.api.ServiceFactory;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.queryparser.psolquery.PSolScorer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;

public class PSolTopScoreDocCollector
implements Collector,
LeafCollector {
    private int numHits = 0;
    private Scorable scorer;
    private int totalHits = 0;
    private int docBase = 0;
    private int docBaseInParent = 0;
    private float scoreFactor = 1.0f;
    private boolean boostCatalogs = true;
    private final DocScoreContainer allDocs = new DocScoreContainer();
    private boolean collectProjects = false;
    private IDocIdIndex docIdIndex = null;
    private PSolScorer psolScorer = null;
    private PathCollectorData pathCollectorData = null;
    private Set<String> collectedChilds = null;
    private ProjectMap idsByProject = null;
    private final Map<String, ProjectMap> collectedProjects = new HashMap<String, ProjectMap>();
    private List<ProjectData> flatPrjData = null;
    private final boolean collectFacets;
    private LeafReaderContext context;
    private final List<FacetsCollector.MatchingDocs> matchingDocs = new ArrayList<FacetsCollector.MatchingDocs>();
    private DocIdSetBuilder docsBuilder;
    private final boolean checkInCommonField;
    private IntArrayList docsFoundInCommonField = null;

    public PSolTopScoreDocCollector(int numHits, boolean collectFacets, boolean checkInCommonField) {
        this.numHits = numHits;
        this.collectFacets = collectFacets;
        this.checkInCommonField = checkInCommonField;
    }

    public void setBoostCatalogs(boolean boost) {
        this.boostCatalogs = boost;
    }

    public void setCollectProjects(boolean collect) {
        this.collectProjects = collect;
    }

    public void setChildFolderFilter(String parentPath) {
        if (parentPath != null) {
            this.pathCollectorData = new PathCollectorData(parentPath);
        }
    }

    public void setCollectChildFolders() {
        this.collectedChilds = new HashSet<String>();
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public long[] getTopDocs() {
        return this.allDocs.getTopDocs(this.numHits);
    }

    public long[] getTopDocs(int num) {
        return this.allDocs.getTopDocs(num);
    }

    public LongArrayList getDocsForProjectEvaluation() {
        if (this.collectProjects) {
            LongArrayList docList = new LongArrayList();
            for (ProjectMap mapByPath : this.collectedProjects.values()) {
                for (ProjectData prjData : mapByPath.values()) {
                    if (prjData.idList.isEmpty()) continue;
                    docList.add(prjData.idList.getLong(0));
                }
            }
            return docList;
        }
        return this.allDocs.docs;
    }

    public List<String> getCollectedChilds() {
        if (this.collectedChilds != null) {
            return new ArrayList<String>(this.collectedChilds);
        }
        if (this.pathCollectorData != null) {
            HashSet<String> result = new HashSet<String>();
            this.pathCollectorData.collectFolderNames(result);
            return new ArrayList<String>(result);
        }
        return null;
    }

    public void reserve(int numHits) {
        this.allDocs.docs.ensureCapacity(numHits);
    }

    public void merge(PSolTopScoreDocCollector collector) {
        int hits = collector.getTotalHits();
        if (hits > 0) {
            this.totalHits += hits;
            this.allDocs.add(collector.allDocs);
            if (this.collectProjects) {
                for (Map.Entry<String, ProjectMap> catEntry : collector.collectedProjects.entrySet()) {
                    ProjectMap map = this.collectedProjects.get(catEntry.getKey());
                    if (map != null) {
                        ProjectMap projectMap = catEntry.getValue();
                        for (Map.Entry entry : projectMap.entrySet()) {
                            ProjectData prjData = map.computeIfAbsent((String)entry.getKey(), k -> new ProjectData());
                            ProjectData newPrjData = (ProjectData)entry.getValue();
                            if (newPrjData.bestScore > prjData.bestScore) {
                                prjData.bestScore = newPrjData.bestScore;
                            }
                            if (newPrjData.minDocId < prjData.minDocId) {
                                prjData.minDocId = newPrjData.minDocId;
                            }
                            prjData.idList.addAll(newPrjData.idList);
                        }
                        continue;
                    }
                    this.collectedProjects.put(catEntry.getKey(), catEntry.getValue());
                }
            }
            if (this.collectFacets) {
                this.matchingDocs.addAll(collector.getMatchingDocs());
            }
            if (collector.pathCollectorData != null && this.collectedChilds != null) {
                collector.pathCollectorData.collectFolderNames(this.collectedChilds);
            }
            if (collector.docsFoundInCommonField != null) {
                if (this.docsFoundInCommonField == null) {
                    this.docsFoundInCommonField = new IntArrayList();
                }
                this.docsFoundInCommonField.addAll(collector.docsFoundInCommonField);
            }
        }
    }

    public List<FacetsCollector.MatchingDocs> getMatchingDocs() {
        if (this.docsBuilder != null) {
            this.matchingDocs.add(new FacetsCollector.MatchingDocs(this.context, this.docsBuilder.build(), this.totalHits, null));
            this.docsBuilder = null;
            this.context = null;
        }
        return this.matchingDocs;
    }

    public IntArrayList getDocsFoundInCommonField() {
        return this.docsFoundInCommonField;
    }

    public TopProjects getTopProjects(int top, int offset, boolean countProjects, Set<String> countedProjects) {
        if (this.flatPrjData == null) {
            this.flatPrjData = new ArrayList<ProjectData>();
            for (ProjectMap item : this.collectedProjects.values()) {
                this.flatPrjData.addAll(item.values());
            }
            this.flatPrjData.sort((p1, p2) -> {
                if (p2.bestScore == p1.bestScore) {
                    return Integer.compare(p1.minDocId, p2.minDocId);
                }
                return Float.compare(p2.bestScore, p1.bestScore);
            });
        }
        LongArrayList docs = new LongArrayList();
        for (int i = 0; i < top && i < this.flatPrjData.size(); ++i) {
            ProjectData data = this.flatPrjData.get(i);
            docs.addAll(data.idList);
        }
        long[] docsArray = docs.toLongArray();
        LongArrays.stableSort(docsArray, offset, docsArray.length, (d1, d2) -> Long.compareUnsigned(d2, d1));
        int projectCount = 0;
        if (countProjects) {
            if (countedProjects != null) {
                for (ProjectMap item : this.collectedProjects.values()) {
                    for (String path : item.keySet()) {
                        if (!countedProjects.add(path)) continue;
                        ++projectCount;
                    }
                }
            } else {
                for (ProjectMap item : this.collectedProjects.values()) {
                    projectCount += item.size();
                }
            }
        }
        TopProjects result = new TopProjects(this.totalHits, docsArray, projectCount);
        return result;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) {
        this.docBase = context.docBase;
        this.docBaseInParent = context.docBaseInParent;
        if (this.collectFacets) {
            if (this.docsBuilder != null) {
                this.matchingDocs.add(new FacetsCollector.MatchingDocs(this.context, this.docsBuilder.build(), this.totalHits, null));
            }
            this.docsBuilder = new DocIdSetBuilder(context.reader().maxDoc());
            this.totalHits = 0;
            this.context = context;
        }
        if (this.boostCatalogs || this.collectProjects || this.pathCollectorData != null) {
            this.scoreFactor = 1.0f;
            FieldDefinitions.CatalogBoost[] boosts = FieldDefinitions.catalogBoost;
            CompositeReader reader = context.parent.reader();
            IIndexManager indexManager = ServiceFactory.getIndexManager();
            IIndexManager.IIndexReaderData readerData = indexManager.findReaderData(reader);
            if (readerData != null) {
                this.scoreFactor = readerData.getBoost();
                if (this.collectProjects) {
                    this.docIdIndex = readerData.getDocIdIndex();
                    this.idsByProject = this.collectedProjects.computeIfAbsent(readerData.getCatalogName(), k -> new ProjectMap());
                }
                if (this.pathCollectorData != null) {
                    this.pathCollectorData.setTreePathIndex(readerData.getTreePathIndex());
                }
                if (!this.boostCatalogs || boosts == null || boosts.length == 0) {
                    return this;
                }
                for (FieldDefinitions.CatalogBoost boost : boosts) {
                    boolean catalogMatches;
                    if (boost == null || !(catalogMatches = boost.byPrefix ? readerData.getCatalogName().startsWith(boost.catalog) : readerData.getCatalogName().equals(boost.catalog))) continue;
                    this.scoreFactor = boost.boost;
                    return this;
                }
            }
        }
        return this;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
        if (this.checkInCommonField) {
            try {
                if (this.findAndSetPSolScorer(scorer)) {
                    this.docsFoundInCommonField = new IntArrayList();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean findAndSetPSolScorer(Scorable scorer) throws IOException {
        if (scorer == null) {
            return false;
        }
        if (scorer instanceof PSolScorer) {
            PSolScorer psScorer;
            this.psolScorer = psScorer = (PSolScorer)scorer;
            return true;
        }
        Collection<Scorable.ChildScorable> childs = scorer.getChildren();
        for (Scorable.ChildScorable child : childs) {
            if (!this.findAndSetPSolScorer(child.child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void collect(int doc) throws IOException {
        float score = this.scorer.score();
        if (this.psolScorer != null && this.psolScorer.foundInCommonField()) {
            this.docsFoundInCommonField.add(doc + this.docBase);
        }
        score *= this.scoreFactor;
        if (this.collectProjects) {
            if (this.docIdIndex != null) {
                String path = this.docIdIndex.getDocPath(doc + this.docBaseInParent);
                int globalDoc = doc + this.docBase;
                ProjectData prjData = this.idsByProject.computeIfAbsent(path, k -> new ProjectData());
                int scoreBits = NumericUtils.floatToSortableInt(score);
                long val = (long)scoreBits << 32 | (long)(globalDoc * -1) & 0xFFFFFFFFL;
                prjData.idList.add(val);
                if (score > prjData.bestScore) {
                    prjData.bestScore = score;
                }
                if (globalDoc < prjData.minDocId) {
                    prjData.minDocId = globalDoc;
                }
            }
        } else {
            this.allDocs.add(doc + this.docBase, score);
        }
        if (this.collectFacets) {
            this.docsBuilder.grow(1).add(doc);
        }
        if (this.pathCollectorData != null) {
            this.pathCollectorData.findMatchingChildPath(doc + this.docBaseInParent);
        }
        ++this.totalHits;
    }

    private static class DocScoreContainer {
        LongArrayList docs = new LongArrayList();
        SortedList lastQueue = null;
        boolean sorted = false;
        private int searchCount = 1;

        private DocScoreContainer() {
        }

        public void add(int docId, float score) {
            int scoreBits = NumericUtils.floatToSortableInt(score);
            long val = (long)scoreBits << 32 | (long)(docId * -1) & 0xFFFFFFFFL;
            this.docs.add(val);
        }

        public void add(DocScoreContainer container) {
            this.docs.addAll(container.docs);
        }

        public long[] getTopDocs(int numHits) {
            long[] topDocs;
            if (this.docs.isEmpty()) {
                return new long[0];
            }
            if (numHits > this.docs.size()) {
                numHits = this.docs.size();
            }
            if (this.sorted) {
                topDocs = this.docs.elements();
                topDocs = Arrays.copyOfRange(topDocs, 0, this.docs.size());
            } else if (numHits > 1000 && this.lastQueue == null) {
                this.docs.sort((k1, k2) -> Long.compareUnsigned(k2, k1));
                this.sorted = true;
                topDocs = this.docs.elements();
                topDocs = Arrays.copyOfRange(topDocs, 0, this.docs.size());
            } else if (this.searchCount > 1) {
                this.lastQueue.putAll(this.docs.elements(), this.docs.size());
                this.sorted = false;
                topDocs = this.lastQueue.getData();
                if (topDocs.length > numHits) {
                    topDocs = Arrays.copyOfRange(topDocs, 0, numHits);
                }
            } else {
                SortedList queue;
                if (this.lastQueue != null) {
                    this.lastQueue.resize(numHits);
                    queue = this.lastQueue;
                } else {
                    this.lastQueue = queue = new SortedList(numHits);
                }
                long[] array = this.docs.elements();
                int size = this.docs.size();
                for (int i = 0; i < size; ++i) {
                    queue.put(array[i]);
                }
                topDocs = queue.getData();
                ++this.searchCount;
            }
            return topDocs;
        }
    }

    class PathCollectorData {
        private final String childFolderFilter;
        private final boolean isCatRoot;
        private ITreePathIndex treePathIndex = null;
        private int parentPathId = -1;
        private IntSet childIds = null;

        PathCollectorData(String treepath) {
            this.childFolderFilter = treepath;
            this.isCatRoot = treepath.equals("cat");
        }

        void setTreePathIndex(ITreePathIndex index) {
            this.treePathIndex = index;
            if (this.treePathIndex != null) {
                this.childIds = new IntOpenHashSet();
                this.parentPathId = this.treePathIndex.getPathId(this.childFolderFilter);
            }
        }

        void findMatchingChildPath(int docId) {
            if (this.treePathIndex != null && this.isCatRoot && !this.childIds.isEmpty()) {
                return;
            }
            this.treePathIndex.findMatchingChildPath(this.parentPathId, docId, this.childIds);
        }

        void collectFolderNames(Set<String> collectedChilds) {
            if (this.childIds != null) {
                IntIterator intIterator = this.childIds.iterator();
                while (intIterator.hasNext()) {
                    int childId = (Integer)intIterator.next();
                    String childName = this.treePathIndex.getName(childId);
                    if (childName == null || childName.isEmpty()) continue;
                    collectedChilds.add(childName);
                }
            }
        }
    }

    private static class ProjectMap
    extends HashMap<String, ProjectData> {
        private ProjectMap() {
        }
    }

    private static class ProjectData {
        LongList idList = new LongArrayList();
        float bestScore = -1.0f;
        int minDocId = Integer.MAX_VALUE;

        private ProjectData() {
        }
    }

    public record TopProjects(int totalHits, long[] scoreDocs, int projectCount) {
    }

    private static class SortedList {
        private final LongSet valueLoookup = new LongOpenHashSet();
        private long[] queue;
        private int size;
        private int index = 0;
        private int currentStartPos = 0;
        private float minScore = Float.MAX_VALUE;
        private boolean sorted = false;

        private void sort() {
            if (!this.sorted) {
                LongArrays.stableSort(this.queue, this.currentStartPos, this.queue.length, (k1, k2) -> Long.compareUnsigned(k2, k1));
                this.sorted = true;
            }
        }

        public SortedList(int size) {
            this.size = size;
            this.queue = new long[size];
        }

        public void resize(int newSize) {
            if (newSize <= this.size) {
                return;
            }
            long[] q = new long[newSize];
            System.arraycopy(this.queue, 0, q, 0, this.queue.length);
            this.queue = q;
            for (int i = 0; i < this.size; ++i) {
                this.valueLoookup.add(this.queue[i]);
            }
            this.currentStartPos = this.size;
            this.size = newSize;
            this.sorted = false;
        }

        public void putAll(long[] values, int count) {
            if (count == this.size) {
                return;
            }
            this.resize(count);
            for (int i = 0; i < count; ++i) {
                long value = values[i];
                if (this.valueLoookup.contains(value)) continue;
                this.queue[this.index++] = value;
            }
            this.sort();
        }

        public void put(long value) {
            if (this.valueLoookup.contains(value)) {
                return;
            }
            int scoreBits = (int)(value >> 32);
            float score = NumericUtils.sortableIntToFloat(scoreBits);
            if (this.index < this.size) {
                this.queue[this.index++] = value;
                if (score < this.minScore) {
                    this.minScore = score;
                }
            } else if (score > this.minScore) {
                this.sort();
                int pos = LongArrays.binarySearch(this.queue, value, (k1, k2) -> Long.compareUnsigned(value, k1));
                if (pos < 0) {
                    pos = -1 - pos;
                }
                if (pos < this.size) {
                    if (pos < this.size - 1) {
                        System.arraycopy(this.queue, pos, this.queue, pos + 1, this.size - pos - 1);
                    }
                    this.queue[pos] = value;
                }
                scoreBits = (int)(this.queue[this.size - 1] >> 32);
                this.minScore = NumericUtils.sortableIntToFloat(scoreBits);
            }
        }

        public long[] getData() {
            this.sort();
            return this.queue;
        }
    }
}

