/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.lucene.search.PSolTopScoreDocCollector;
import java.util.Collection;
import org.apache.lucene.search.CollectorManager;

public class PSolTopScoreDocCollectorManager
implements CollectorManager<PSolTopScoreDocCollector, PSolTopScoreDocCollector> {
    private final int numHits;
    private final boolean collectFacets;
    private final boolean boostCatalogs;
    private final boolean collectProjects;
    private final boolean checkInCommonField;
    private final String childFolderFilter;

    public PSolTopScoreDocCollectorManager(int numHits, boolean collectFacets, boolean boostCatalogs, boolean collectProjects, boolean checkInCommonField, String childFolderFilter) {
        this.numHits = numHits;
        this.collectFacets = collectFacets;
        this.boostCatalogs = boostCatalogs;
        this.collectProjects = collectProjects;
        this.checkInCommonField = checkInCommonField;
        this.childFolderFilter = childFolderFilter;
    }

    @Override
    public PSolTopScoreDocCollector newCollector() {
        PSolTopScoreDocCollector collector = new PSolTopScoreDocCollector(this.numHits, this.collectFacets, this.checkInCommonField);
        collector.setBoostCatalogs(this.boostCatalogs);
        collector.setCollectProjects(this.collectProjects);
        collector.setChildFolderFilter(this.childFolderFilter);
        return collector;
    }

    @Override
    public PSolTopScoreDocCollector reduce(Collection<PSolTopScoreDocCollector> collectors) {
        if (collectors == null || collectors.isEmpty()) {
            return new PSolTopScoreDocCollector(this.numHits, this.collectFacets, this.checkInCommonField);
        }
        if (collectors.size() == 1) {
            return collectors.iterator().next();
        }
        PSolTopScoreDocCollector reduced = new PSolTopScoreDocCollector(this.numHits, this.collectFacets, this.checkInCommonField);
        reduced.setCollectProjects(this.collectProjects);
        reduced.setCollectChildFolders();
        int totalHits = 0;
        for (PSolTopScoreDocCollector collector : collectors) {
            totalHits += collector.getTotalHits();
        }
        reduced.reserve(totalHits);
        for (PSolTopScoreDocCollector collector : collectors) {
            reduced.merge(collector);
        }
        return reduced;
    }
}

