/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.search;

import de.cadenas.catalogsearch.api.ISearchResultFilter;
import de.cadenas.catalogsearch.api.ISearchResultFilterValue;
import de.cadenas.catalogsearch.api.impl.SearchResultFilterImpl;
import de.cadenas.catalogsearch.api.impl.SearchResultFilterValueImpl;
import de.cadenas.catalogsearch.api.impl.SearchResultImpl;
import de.cadenas.catalogsearch.lucene.FieldDefinitions;
import de.cadenas.catalogsearch.lucene.facet.IFacetListBuilder;
import de.cadenas.catalogsearch.lucene.facet.MinMaxFacetCounts;
import de.cadenas.catalogsearch.lucene.index.ErpConfiguration;
import de.cadenas.catalogsearch.lucene.search.FacetCountingFilter;
import de.cadenas.util.PGenericPair;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.jetbrains.annotations.NotNull;

public class SearchResultBuilder {
    private final Map<String, ProcessedFilter> foundVariables = new HashMap<String, ProcessedFilter>();
    private final Map<String, ProcessedFilter> foundTextVariables = new HashMap<String, ProcessedFilter>();
    private final FacetCountingFilter facetFilter;
    private final List<String> languageList;
    private final List<String> facetNameFilter;
    private Set<String> excludeFacetFilter;
    private List<String> excludePrefixFilter;
    private Set<String> includeFacetFilter;
    private List<String> includePrefixFilter;
    private boolean includeFilterAssistantFacets = false;
    private int variableFacetCount = 20;
    private final NumberFormat format;

    public SearchResultBuilder(FacetCountingFilter facetFilter, List<String> facetNameFilter, List<String> languageList) {
        this.facetFilter = facetFilter;
        this.languageList = languageList;
        this.format = NumberFormat.getNumberInstance(Locale.ROOT);
        this.format.setMaximumFractionDigits(8);
        this.format.setGroupingUsed(false);
        this.facetNameFilter = facetNameFilter;
        if (facetNameFilter != null && !facetNameFilter.isEmpty()) {
            this.excludeFacetFilter = new HashSet<String>();
            this.excludePrefixFilter = new ArrayList<String>();
            this.includeFacetFilter = new HashSet<String>();
            this.includePrefixFilter = new ArrayList<String>();
            for (String filter : facetNameFilter) {
                if (filter.startsWith("-")) {
                    if (filter.length() <= 1) continue;
                    if (filter.endsWith("*")) {
                        this.excludePrefixFilter.add(filter.substring(1, filter.length() - 2));
                        continue;
                    }
                    this.excludeFacetFilter.add(filter.substring(1));
                    continue;
                }
                if (filter.endsWith("*")) {
                    this.includePrefixFilter.add(filter.substring(0, filter.length() - 1));
                    continue;
                }
                this.includeFacetFilter.add(filter);
            }
        }
    }

    public void setIncludeFilterAssistantFacets(boolean include) {
        this.includeFilterAssistantFacets = include;
    }

    private boolean includeFacet(String facetName, String dimName) {
        if (this.facetNameFilter == null) {
            return true;
        }
        if (this.includeFacetFilter.contains(facetName) || this.includeFacetFilter.contains(dimName)) {
            return true;
        }
        for (String prefix : this.includePrefixFilter) {
            if (!facetName.startsWith(prefix) && !dimName.startsWith(prefix)) continue;
            return true;
        }
        if (this.excludeFacetFilter.contains(facetName) || this.excludeFacetFilter.contains(dimName)) {
            return false;
        }
        for (String prefix : this.excludePrefixFilter) {
            if (!facetName.startsWith(prefix) && !dimName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private PGenericPair<Double, Double> getMinMax(ISearchResultFilter filter) {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        List<ISearchResultFilterValue> values = filter.getValues();
        for (ISearchResultFilterValue value : values) {
            try {
                double val = Double.parseDouble(value.getValue());
                if (val < minValue) {
                    minValue = val;
                }
                if (!(val > maxValue)) continue;
                maxValue = val;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new PGenericPair<Double, Double>(minValue, maxValue);
    }

    private PGenericPair<Double, Double> getMinMax(double minValue, double maxValue, MinMaxFacetCounts.MinMaxValue minMax) {
        if (minMax.useValueList) {
            DoubleListIterator doubleListIterator = minMax.valueList.iterator();
            while (doubleListIterator.hasNext()) {
                double val = (Double)doubleListIterator.next();
                if (val < minValue) {
                    minValue = val;
                }
                if (!(val > maxValue)) continue;
                maxValue = val;
            }
        } else {
            if (minMax.minValue < minValue) {
                minValue = minMax.minValue;
            }
            if (minMax.minValue > maxValue) {
                maxValue = minMax.minValue;
            }
            if (minMax.maxValue < minValue) {
                minValue = minMax.maxValue;
            }
            if (minMax.maxValue > maxValue) {
                maxValue = minMax.maxValue;
            }
        }
        return new PGenericPair<Double, Double>(minValue, maxValue);
    }

    private void createMinMax(ISearchResultFilter filter, double min, double max, int matchCount) {
        SearchResultFilterValueImpl searchFilterMinValue = new SearchResultFilterValueImpl();
        searchFilterMinValue.value = this.format.format(min);
        searchFilterMinValue.matchCount = matchCount;
        filter.getValues().add(searchFilterMinValue);
        SearchResultFilterValueImpl searchFilterMaxValue = new SearchResultFilterValueImpl();
        searchFilterMaxValue.value = this.format.format(max);
        searchFilterMaxValue.matchCount = matchCount;
        filter.getValues().add(searchFilterMaxValue);
    }

    public static void filterLanguageDependentFacets(List<FacetResult> list1, List<FacetResult> list2, List<String> languageList) {
        HashMap<String, List<String>> varFacets = new HashMap<String, List<String>>();
        SearchResultBuilder.collectVarFacets(list1, languageList, varFacets);
        SearchResultBuilder.collectVarFacets(list2, languageList, varFacets);
        if (!varFacets.isEmpty()) {
            List<PGenericPair<String, String>> toRemove = SearchResultBuilder.createRemoveList(languageList, varFacets);
            SearchResultBuilder.removeFacetResults(list1, toRemove);
            SearchResultBuilder.removeFacetResults(list2, toRemove);
        }
    }

    @NotNull
    private static List<PGenericPair<String, String>> createRemoveList(List<String> languageList, Map<String, List<String>> varFacets) {
        ArrayList<PGenericPair<String, String>> toRemove = new ArrayList<PGenericPair<String, String>>();
        varFacets.forEach((k, v) -> {
            Optional<String> lang = v.stream().min(Comparator.comparingInt(languageList::indexOf));
            lang.ifPresent(s -> v.forEach(l -> {
                if (!l.equals(s)) {
                    toRemove.add(new PGenericPair<String, String>((String)k, (String)l));
                }
            }));
        });
        return toRemove;
    }

    private static void removeFacetResults(List<FacetResult> list1, List<PGenericPair<String, String>> toRemove) {
        for (int i = list1.size() - 1; i >= 0; --i) {
            String label = list1.get((int)i).dim;
            boolean remove = false;
            for (PGenericPair<String, String> p : toRemove) {
                int i1 = label.indexOf((String)p.second);
                int i2 = label.indexOf((String)p.first);
                if (i2 <= -1 || i1 <= i2) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            list1.remove(i);
        }
    }

    private static void collectVarFacets(List<FacetResult> facetResults, List<String> languageList, Map<String, List<String>> varFacets) {
        for (int i = facetResults.size() - 1; i >= 0; --i) {
            PGenericPair<String, String> varAndLang;
            FacetResult fr = facetResults.get(i);
            if (fr == null || !fr.dim.endsWith("_lang") || (varAndLang = FieldDefinitions.getLanguageAndVarName(fr.dim)) == null) continue;
            if (!languageList.contains(varAndLang.first)) {
                facetResults.remove(i);
                continue;
            }
            if (fr.dim.startsWith("facet_erp_")) {
                varAndLang.second = FieldDefinitions.getVarNameFromErpFacet(fr.dim);
            }
            List values = varFacets.computeIfAbsent((String)varAndLang.second, k -> new ArrayList());
            values.add((String)varAndLang.first);
        }
    }

    private void filterLanguageDependentFacets(List<FacetResult> facetResults) {
        HashMap<String, List<String>> varFacets = new HashMap<String, List<String>>();
        SearchResultBuilder.collectVarFacets(facetResults, this.languageList, varFacets);
        if (!varFacets.isEmpty()) {
            List<PGenericPair<String, String>> toRemove = SearchResultBuilder.createRemoveList(this.languageList, varFacets);
            SearchResultBuilder.removeFacetResults(facetResults, toRemove);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void fillSearchResultWithMinMax(SearchResultImpl searchResult, List<FacetResult> facetResults, List<FacetsCollector.MatchingDocs> matchingDocs, Map<String, IFacetListBuilder.Result.NumericSideway> numericSideways, String erpGroupName) {
        boolean isErpIndex = erpGroupName != null;
        ErpConfiguration erpConfiguration = ErpConfiguration.getInstance();
        HashSet<String> requiredVariables = null;
        if (numericSideways != null && !numericSideways.isEmpty()) {
            requiredVariables = new HashSet<String>(numericSideways.keySet());
        }
        if (!this.foundVariables.isEmpty()) {
            for (Map.Entry<String, ProcessedFilter> fv : this.foundVariables.entrySet()) {
                if (fv.getValue().isErp == isErpIndex) continue;
                if (requiredVariables == null) {
                    requiredVariables = new HashSet();
                }
                requiredVariables.add(fv.getKey());
            }
        }
        for (int f = facetResults.size() - 1; f >= 0; --f) {
            FacetResult fr = facetResults.get(f);
            if (fr == null) continue;
            MinMaxFacetCounts.MinMaxValue[] minMaxList = new MinMaxFacetCounts.MinMaxValue[]{};
            int count = 0;
            boolean isErp = fr.dim.equals("facet_erp_numvar") || fr.dim.equals("facet_erp_rangevar");
            boolean isNumeric = isErp;
            if (!isNumeric) {
                isNumeric = fr.dim.equals("facet_numvar") || fr.dim.equals("facet_rangevar");
            }
            boolean isNumVar = fr.dim.equals("facet_numvar") || fr.dim.equals("facet_erp_numvar");
            boolean isRangeVar = false;
            if (isNumeric) {
                isRangeVar = fr.dim.equals("facet_rangevar") || fr.dim.equals("facet_erp_rangevar");
                facetResults.remove(f);
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<LabelAndValue> labelAndValues = new ArrayList<LabelAndValue>(Arrays.asList(fr.labelValues));
                if (this.facetNameFilter != null) {
                    ArrayList<Object> sortedLabels = new ArrayList<Object>();
                    block2: for (String string : this.facetNameFilter) {
                        if (string.startsWith("-")) continue;
                        if (string.endsWith("*")) {
                            String prefix = string.substring(0, string.length() - 1);
                            for (int i = 0; i < labelAndValues.size(); ++i) {
                                LabelAndValue lav = (LabelAndValue)labelAndValues.get(i);
                                if (!fr.dim.startsWith(prefix) && !lav.label.startsWith(prefix)) continue;
                                sortedLabels.add(lav);
                                labelAndValues.remove(i);
                                continue block2;
                            }
                            continue;
                        }
                        for (int i = 0; i < labelAndValues.size(); ++i) {
                            LabelAndValue lav = (LabelAndValue)labelAndValues.get(i);
                            if (!fr.dim.equals(string) && !lav.label.equals(string)) continue;
                            sortedLabels.add(lav);
                            labelAndValues.remove(i);
                            continue block2;
                        }
                    }
                    sortedLabels.addAll(labelAndValues);
                    labelAndValues = sortedLabels;
                }
                for (int i = 0; i < labelAndValues.size(); ++i) {
                    ProcessedFilter processedFilter;
                    String fieldName = ((LabelAndValue)labelAndValues.get((int)i)).label;
                    if (!this.includeFacet(fieldName, fr.dim) || !this.includeFilterAssistantFacets && fieldName.startsWith("f:") || (processedFilter = this.foundVariables.get(fieldName)) != null && processedFilter.isErp == isErpIndex && processedFilter.isRange != isRangeVar) continue;
                    if (isErp) {
                        String fieldNameToCheck = fieldName;
                        int sepIndex = fieldNameToCheck.indexOf(64);
                        if (sepIndex != -1) {
                            fieldNameToCheck = fieldNameToCheck.substring(0, sepIndex);
                        }
                        if (!erpConfiguration.isVariableVisible(fieldNameToCheck, erpGroupName)) continue;
                        fieldNames.add(fieldName);
                        continue;
                    }
                    boolean addField = false;
                    if (count >= this.variableFacetCount) {
                        if (requiredVariables == null) break;
                        String postfix = "_" + fieldName.toLowerCase();
                        for (String fName : requiredVariables) {
                            if (!fName.equals(fieldName) && !fName.endsWith(postfix)) continue;
                            requiredVariables.remove(fName);
                            if (requiredVariables.isEmpty()) {
                                requiredVariables = null;
                            }
                            addField = true;
                            break;
                        }
                    } else {
                        addField = true;
                    }
                    if (addField) {
                        fieldNames.add(fieldName);
                        ++count;
                        continue;
                    }
                    searchResult.moreFacetsAvailable = true;
                }
                MinMaxFacetCounts minMaxCounter = new MinMaxFacetCounts(numericSideways, this.facetFilter);
                minMaxList = minMaxCounter.getMinMaxValuesConcurrent(fieldNames, matchingDocs);
            }
            if (minMaxList.length <= 0) continue;
            for (int i = 0; i < minMaxList.length; ++i) {
                MinMaxFacetCounts.MinMaxValue minMaxVal = minMaxList[i];
                ProcessedFilter processedFilter = this.foundVariables.get(minMaxVal.fieldName);
                if (processedFilter != null) {
                    SearchResultFilterImpl filter = processedFilter.filter;
                    if (isErpIndex != processedFilter.isErp || processedFilter.isRange != isRangeVar) {
                        filter.matchCount += minMaxVal.matchCount;
                    }
                    if (!filter.useValueList || !minMaxVal.useValueList) {
                        PGenericPair<Double, Double> pGenericPair2 = this.getMinMax(filter);
                        pGenericPair2 = this.getMinMax((Double)pGenericPair2.first, (Double)pGenericPair2.second, minMaxVal);
                        filter.useValueList = false;
                        filter.getValues().clear();
                        this.createMinMax(filter, (Double)pGenericPair2.first, (Double)pGenericPair2.second, 1);
                        continue;
                    }
                    List<ISearchResultFilterValue> list = filter.getValues();
                    int firstIndex = 0;
                    if (filter.useMinMax || !filter.useValueList && list.size() >= 2) {
                        if (minMaxVal.useMinMax) {
                            double oldMax;
                            double oldMin = Double.parseDouble(list.get(0).getValue());
                            if (minMaxVal.minValue < oldMin) {
                                ((SearchResultFilterValueImpl)list.get((int)0)).value = this.format.format(minMaxVal.minValue);
                            }
                            if (minMaxVal.maxValue > (oldMax = Double.parseDouble(list.get(1).getValue()))) {
                                ((SearchResultFilterValueImpl)list.get((int)1)).value = this.format.format(minMaxVal.maxValue);
                            }
                        }
                        firstIndex = 2;
                    } else if (minMaxVal.useMinMax) {
                        SearchResultFilterValueImpl filterValue = new SearchResultFilterValueImpl();
                        filterValue.value = this.format.format(minMaxVal.maxValue);
                        list.add(0, filterValue);
                        filterValue = new SearchResultFilterValueImpl();
                        filterValue.value = this.format.format(minMaxVal.minValue);
                        list.add(0, filterValue);
                        firstIndex = 2;
                    }
                    int lastIndex = list.size();
                    for (int v = 0; v < minMaxVal.valueList.size(); ++v) {
                        double val = minMaxVal.valueList.getDouble(v);
                        String strVal = this.format.format(val);
                        boolean found = false;
                        for (int fv = firstIndex; fv < lastIndex; ++fv) {
                            ISearchResultFilterValue filterValue = list.get(fv);
                            if (!filterValue.getValue().equals(strVal)) continue;
                            ((SearchResultFilterValueImpl)filterValue).matchCount += minMaxVal.matchCountList.getInt(v);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        SearchResultFilterValueImpl filterValue = new SearchResultFilterValueImpl();
                        filterValue.value = strVal;
                        filterValue.matchCount = minMaxVal.matchCountList.getInt(v);
                        list.add(filterValue);
                    }
                    continue;
                }
                SearchResultFilterImpl searchFilter = new SearchResultFilterImpl();
                searchFilter.isRangeFilter = true;
                searchFilter.useValueList = minMaxVal.useValueList;
                searchFilter.useMinMax = minMaxVal.useMinMax;
                searchFilter.matchCount = minMaxVal.matchCount;
                searchFilter.isErp = isErp;
                searchFilter.name = "facet_var_" + minMaxVal.fieldName;
                processedFilter = new ProcessedFilter(searchFilter, isErpIndex, isRangeVar);
                this.foundVariables.put(minMaxVal.fieldName, processedFilter);
                if (!minMaxVal.useValueList || minMaxVal.useMinMax) {
                    int n = minMaxVal.matchCountList.size() > 0 ? minMaxVal.matchCountList.getInt(0) : 1;
                    this.createMinMax(searchFilter, minMaxVal.minValue, minMaxVal.maxValue, n);
                }
                if (minMaxVal.useValueList) {
                    void var21_32;
                    boolean bl = false;
                    while (var21_32 < minMaxVal.valueList.size()) {
                        SearchResultFilterValueImpl searchFilterValue = new SearchResultFilterValueImpl();
                        searchFilterValue.value = this.format.format(minMaxVal.valueList.getDouble((int)var21_32));
                        searchFilterValue.matchCount = minMaxVal.matchCountList.getInt((int)var21_32);
                        searchFilter.values.add(searchFilterValue);
                        ++var21_32;
                    }
                }
                searchResult.filters.add(searchFilter);
            }
        }
    }

    public void fillSearchResultWithFacets(SearchResultImpl searchResult, List<FacetResult> facetResults, String erpGroupName) {
        int countVarFacets = 0;
        ErpConfiguration erpConfiguration = ErpConfiguration.getInstance();
        this.filterLanguageDependentFacets(facetResults);
        if (this.facetNameFilter != null && !this.facetNameFilter.isEmpty()) {
            ArrayList<FacetResult> sortedFacets = new ArrayList<FacetResult>();
            block0: for (String filter : this.facetNameFilter) {
                if (filter.startsWith("-") || filter.contains("@")) continue;
                if (filter.endsWith("*")) {
                    String prefix = filter.substring(0, filter.length() - 1);
                    for (int i = 0; i < facetResults.size(); ++i) {
                        FacetResult fr = facetResults.get(i);
                        if (fr == null || !fr.dim.startsWith(prefix)) continue;
                        sortedFacets.add(fr);
                        facetResults.remove(i);
                        continue block0;
                    }
                    continue;
                }
                for (int i = 0; i < facetResults.size(); ++i) {
                    FacetResult fr = facetResults.get(i);
                    if (fr == null || !fr.dim.equals(filter)) continue;
                    sortedFacets.add(fr);
                    facetResults.remove(i);
                    continue block0;
                }
            }
            sortedFacets.addAll(facetResults);
            facetResults = sortedFacets;
        }
        for (FacetResult fr : facetResults) {
            ProcessedFilter processedFilter;
            if (fr == null) continue;
            boolean isErp = false;
            if (!this.includeFacet("", fr.dim)) continue;
            if (fr.dim.startsWith("facet_text")) {
                if (++countVarFacets >= this.variableFacetCount && !this.foundTextVariables.containsKey(fr.dim)) {
                    searchResult.moreFacetsAvailable = true;
                    continue;
                }
            } else if (fr.dim.startsWith("facet_erp_")) {
                String varName = FieldDefinitions.getVarNameFromErpFacet(fr.dim);
                if (!varName.isEmpty() && !erpConfiguration.isVariableVisible(varName, erpGroupName)) continue;
                isErp = true;
            }
            if ((processedFilter = this.foundTextVariables.get(fr.dim)) != null) {
                SearchResultFilterImpl filter = processedFilter.filter;
                filter.matchCount += fr.childCount;
                List<ISearchResultFilterValue> valueList = filter.getValues();
                for (LabelAndValue labelAndValue : fr.labelValues) {
                    boolean found = false;
                    for (ISearchResultFilterValue filterValue : valueList) {
                        if (!filterValue.getValue().equals(labelAndValue.label)) continue;
                        ((SearchResultFilterValueImpl)filterValue).matchCount += labelAndValue.value.intValue();
                        found = true;
                        break;
                    }
                    if (found) continue;
                    SearchResultFilterValueImpl filterValue = new SearchResultFilterValueImpl();
                    filterValue.value = labelAndValue.label;
                    filterValue.matchCount = labelAndValue.value.intValue();
                    valueList.add(filterValue);
                }
                continue;
            }
            SearchResultFilterImpl searchFilter = new SearchResultFilterImpl();
            searchFilter.isErp = isErp;
            searchFilter.name = fr.dim;
            searchFilter.matchCount = fr.childCount;
            for (int i = 0; i < fr.labelValues.length; ++i) {
                SearchResultFilterValueImpl searchFilterValue = new SearchResultFilterValueImpl();
                searchFilterValue.value = fr.labelValues[i].label;
                searchFilterValue.matchCount = fr.labelValues[i].value.intValue();
                searchFilter.values.add(searchFilterValue);
            }
            searchResult.filters.add(searchFilter);
            processedFilter = new ProcessedFilter(searchFilter, isErp, false);
            this.foundTextVariables.put(fr.dim, processedFilter);
        }
    }

    public void setVariableFacetCount(int count) {
        this.variableFacetCount = count;
    }

    private static class ProcessedFilter {
        SearchResultFilterImpl filter;
        boolean isErp;
        boolean isRange;

        public ProcessedFilter(SearchResultFilterImpl filter, boolean erp, boolean range) {
            this.filter = filter;
            this.isErp = erp;
            this.isRange = range;
        }

        public String toString() {
            if (this.filter == null) {
                return "";
            }
            return this.filter.toString();
        }
    }
}

