/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.spell;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;

public class SpellChecker {
    private static final String F_WORD = "word";
    private static final String F_STEMMED = "stemmed";
    private static final String F_LANGUAGE = "language";
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private StringDistance sd;
    private Comparator<SuggestWord> comparator;

    public SpellChecker(StringDistance sd) throws IOException {
        this(sd, SuggestWordQueue.DEFAULT_COMPARATOR);
    }

    public SpellChecker() throws IOException {
        this((StringDistance)new LevenshteinDistance());
    }

    public SpellChecker(StringDistance sd, Comparator<SuggestWord> comparator) throws IOException {
        this.setStringDistance(sd);
        this.comparator = comparator;
    }

    public void setComparator(Comparator<SuggestWord> comparator) {
        this.comparator = comparator;
    }

    public Comparator<SuggestWord> getComparator() {
        return this.comparator;
    }

    public void setStringDistance(StringDistance sd) {
        this.sd = sd;
    }

    public StringDistance getStringDistance() {
        return this.sd;
    }

    public String[] suggestSimilar(IndexSearcher indexSearcher, String word, List<String> languageList, int numSug, float accuracy, int lengthAccuracy) throws IOException {
        String lowWord = word.toLowerCase();
        int lengthWord = lowWord.length();
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        if (languageList.size() == 1) {
            query.add(new BooleanClause(new TermQuery(new Term(F_LANGUAGE, languageList.get(0))), BooleanClause.Occur.MUST));
        } else {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            for (int l = 0; l < languageList.size(); ++l) {
                String language = languageList.get(l);
                Query lquery = new TermQuery(new Term(F_LANGUAGE, language));
                if (l == 0) {
                    lquery = new BoostQuery(lquery, 100.0f);
                }
                q.add(new BooleanClause(lquery, BooleanClause.Occur.SHOULD));
            }
            query.add(q.build(), BooleanClause.Occur.MUST);
        }
        BooleanQuery.Builder subQuery = new BooleanQuery.Builder();
        for (int ng = SpellChecker.getMin(lengthWord); ng <= SpellChecker.getMax(lengthWord); ++ng) {
            String key = "gram" + ng;
            String[] grams = SpellChecker.formGrams(lowWord, ng);
            if (grams.length == 0) continue;
            if (this.bStart > 0.0f) {
                SpellChecker.add(subQuery, "start" + ng, grams[0], this.bStart);
            }
            if (this.bEnd > 0.0f) {
                SpellChecker.add(subQuery, "end" + ng, grams[grams.length - 1], this.bEnd);
            }
            for (int i = 0; i < grams.length; ++i) {
                SpellChecker.add(subQuery, key, grams[i]);
            }
        }
        query.add(subQuery.build(), BooleanClause.Occur.MUST);
        int maxHits = 100 * numSug;
        ScoreDoc[] hits = indexSearcher.search((Query)query.build(), (int)maxHits).scoreDocs;
        SuggestWordQueue sugQueue = new SuggestWordQueue(numSug, this.comparator);
        TreeSet<String> duplicates = new TreeSet<String>((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        duplicates.add(word);
        int minwlen = lengthWord - lengthAccuracy;
        int maxwlen = lengthWord + lengthAccuracy;
        int stop = Math.min(hits.length, maxHits);
        SuggestWord sugWord = new SuggestWord();
        for (int i = 0; i < stop; ++i) {
            Document doc = indexSearcher.doc(hits[i].doc);
            sugWord.string = doc.get(F_WORD);
            if (sugWord.string.length() < minwlen || sugWord.string.length() > maxwlen) continue;
            String stemmed = doc.get(F_STEMMED);
            if (stemmed == null || stemmed.isEmpty()) {
                stemmed = sugWord.string;
            }
            if (duplicates.contains(stemmed)) continue;
            duplicates.add(stemmed);
            sugWord.score = this.sd.getDistance(lowWord, stemmed);
            if (sugWord.score < accuracy) continue;
            if (hits[i].score > 100.0f) {
                sugWord.score += 100.0f;
            }
            sugQueue.insertWithOverflow((Object)sugWord);
            if (sugQueue.size() == numSug) {
                accuracy = ((SuggestWord)sugQueue.top()).score;
            }
            sugWord = new SuggestWord();
        }
        String[] list = new String[sugQueue.size()];
        for (int i = sugQueue.size() - 1; i >= 0; --i) {
            list[i] = ((SuggestWord)sugQueue.pop()).string;
        }
        return list;
    }

    private static void add(BooleanQuery.Builder q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        q.add(new BooleanClause(new BoostQuery(tq, boost), BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery.Builder q, String name, String value) {
        q.add(new BooleanClause(new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    static int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    static int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    static Document createDocument(String text, String language, int ng1, int ng2) {
        Document doc = new Document();
        StringField f = new StringField(F_WORD, text, Field.Store.YES);
        doc.add(f);
        String stemmed = text.toLowerCase();
        if (!stemmed.equals(text)) {
            StringField fs = new StringField(F_STEMMED, stemmed, Field.Store.YES);
            doc.add(fs);
        }
        SpellChecker.addGram(stemmed, doc, ng1, ng2);
        StringField langField = new StringField(F_LANGUAGE, language, Field.Store.NO);
        doc.add(langField);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                FieldType ft = new FieldType(StringField.TYPE_NOT_STORED);
                ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
                Field ngramField = new Field(key, gram, (IndexableFieldType)ft);
                doc.add(ngramField);
                if (i == 0) {
                    StringField startField = new StringField("start" + ng, gram, Field.Store.NO);
                    doc.add(startField);
                }
                end = gram;
            }
            if (end == null) continue;
            StringField endField = new StringField("end" + ng, end, Field.Store.NO);
            doc.add(endField);
        }
    }
}

