/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.catalogsearch.lucene.spell;

import de.cadenas.catalogsearch.lucene.index.CatalogIndexer;
import de.cadenas.catalogsearch.lucene.spell.SpellChecker;
import de.cadenas.util.PLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.FSDirectory;

public class SpellIndexer {
    private static PLogger logger = new PLogger(CatalogIndexer.class.getSimpleName());
    private final Path _indexPath;
    private final IndexWriterConfig.OpenMode _openMode;
    private IndexWriter _indexWriter;

    public SpellIndexer(String absolutePath, IndexWriterConfig.OpenMode openMode) throws Exception {
        this._indexPath = Paths.get(absolutePath, new String[0]);
        this._openMode = openMode;
        this.init();
    }

    public void commit() throws Exception {
        this._indexWriter.commit();
    }

    public synchronized void close() throws Exception {
        if (this._indexWriter.isOpen()) {
            this._indexWriter.forceMerge(1, true);
        }
        this._indexWriter.close();
    }

    private void init() throws Exception {
        FSDirectory directory = FSDirectory.open(this._indexPath);
        IndexWriterConfig config = new IndexWriterConfig(null);
        config.setOpenMode(this._openMode);
        config.setMergeScheduler(new SerialMergeScheduler());
        config.setUseCompoundFile(false);
        config.setRAMBufferSizeMB(48.0);
        this._indexWriter = new IndexWriter(directory, config);
    }

    public synchronized void addWords(String language, List<String> words) {
        for (String word : words) {
            int len = word.length();
            if (len < 3) continue;
            Document doc = SpellChecker.createDocument(word, language, SpellChecker.getMin(len), SpellChecker.getMax(len));
            try {
                this._indexWriter.addDocument(doc);
            }
            catch (IOException ex) {
                logger.error("Error adding documents to spell index");
            }
        }
    }
}

