/*
 * Decompiled with CFR 0.152.
 */
package de.cadenas.util;

public class PConfig
implements AutoCloseable {
    private String fileName;

    private static native void openConfig(String var0);

    private static native void writeConfig(String var0);

    private static native void clearConfig(String var0);

    private static native void closeConfig(String var0);

    private static native String getConfigString(String var0, String var1, String var2);

    private static native boolean getConfigBool(String var0, String var1, String var2);

    private static native int getConfigInt(String var0, String var1, String var2, int var3);

    private static native String[] getConfigStringArray(String var0, String var1, String var2);

    private static native String[] getConfigNumberedValues(String var0, String var1, String var2, int var3);

    private static native String[] getConfigBlocks(String var0);

    private static native String[] getConfigKeys(String var0, String var1);

    private static native void writeConfigString(String var0, String var1, String var2, String var3);

    public PConfig(String fileName) {
        this.fileName = fileName;
        PConfig.openConfig(fileName);
    }

    public String getValue(String key, String block) {
        return PConfig.getConfigString(this.fileName, key, block);
    }

    public boolean getBool(String key, String block) {
        return PConfig.getConfigBool(this.fileName, key, block);
    }

    public int getInt(String key, String block) {
        return this.getInt(key, block, 0);
    }

    public int getInt(String key, String block, int defaultValue) {
        return PConfig.getConfigInt(this.fileName, key, block, defaultValue);
    }

    public String[] getStringArray(String key, String block) {
        return PConfig.getConfigStringArray(this.fileName, key, block);
    }

    public String[] getNumberedValues(String key, String block, int maxCount) {
        return PConfig.getConfigNumberedValues(this.fileName, key, block, maxCount);
    }

    public String[] getBlocks() {
        return PConfig.getConfigBlocks(this.fileName);
    }

    public String[] getKeys(String block) {
        return PConfig.getConfigKeys(this.fileName, block);
    }

    public void writeString(String key, String block, String value) {
        PConfig.writeConfigString(this.fileName, key, block, value);
    }

    public void clearConfig() {
        PConfig.clearConfig(this.fileName);
    }

    public void write() {
        PConfig.writeConfig(this.fileName);
    }

    @Override
    public void close() {
        if (this.fileName != null) {
            PConfig.closeConfig(this.fileName);
            this.fileName = null;
        }
    }
}

