/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;

public class KnnVectorField
extends Field {
    private static FieldType createType(float[] v, VectorSimilarityFunction similarityFunction) {
        if (v == null) {
            throw new IllegalArgumentException("vector value must not be null");
        }
        int dimension = v.length;
        if (dimension == 0) {
            throw new IllegalArgumentException("cannot index an empty vector");
        }
        if (dimension > VectorValues.MAX_DIMENSIONS) {
            throw new IllegalArgumentException("cannot index vectors with dimension greater than " + VectorValues.MAX_DIMENSIONS);
        }
        if (similarityFunction == null) {
            throw new IllegalArgumentException("similarity function must not be null");
        }
        FieldType type = new FieldType();
        type.setVectorDimensionsAndSimilarityFunction(dimension, similarityFunction);
        type.freeze();
        return type;
    }

    public static FieldType createFieldType(int dimension, VectorSimilarityFunction similarityFunction) {
        FieldType type = new FieldType();
        type.setVectorDimensionsAndSimilarityFunction(dimension, similarityFunction);
        type.freeze();
        return type;
    }

    public KnnVectorField(String name, float[] vector, VectorSimilarityFunction similarityFunction) {
        super(name, KnnVectorField.createType(vector, similarityFunction));
        this.fieldsData = vector;
    }

    public KnnVectorField(String name, float[] vector) {
        this(name, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    public KnnVectorField(String name, float[] vector, FieldType fieldType) {
        super(name, fieldType);
        this.fieldsData = vector;
    }

    public float[] vectorValue() {
        return (float[])this.fieldsData;
    }

    public void setVectorValue(float[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value.length != this.type.vectorDimension()) {
            throw new IllegalArgumentException("value length " + value.length + " must match field dimension " + this.type.vectorDimension());
        }
        this.fieldsData = value;
    }
}

