/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.SpatialQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class XYShapeQuery
extends SpatialQuery {
    final XYGeometry[] geometries;
    private final Component2D component2D;

    XYShapeQuery(String field, ShapeField.QueryRelation queryRelation, XYGeometry ... geometries) {
        super(field, queryRelation);
        this.component2D = XYGeometry.create(geometries);
        this.geometries = (XYGeometry[])geometries.clone();
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        return new SpatialQuery.SpatialVisitor(){

            @Override
            protected PointValues.Relation relate(byte[] minTriangle, byte[] maxTriangle) {
                double minY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, 0));
                double minX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, 4));
                double maxY = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, 8));
                double maxX = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, 12));
                return XYShapeQuery.this.component2D.relate(minX, maxX, minY, maxY);
            }

            @Override
            protected Predicate<byte[]> intersects() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double y = XYEncodingUtils.decode(scratchTriangle.aY);
                            double x = XYEncodingUtils.decode(scratchTriangle.aX);
                            return XYShapeQuery.this.component2D.contains(x, y);
                        }
                        case LINE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            return XYShapeQuery.this.component2D.intersectsLine(aX, aY, bX, bY);
                        }
                        case TRIANGLE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                            double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                            return XYShapeQuery.this.component2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }

            @Override
            protected Predicate<byte[]> within() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double y = XYEncodingUtils.decode(scratchTriangle.aY);
                            double x = XYEncodingUtils.decode(scratchTriangle.aX);
                            return XYShapeQuery.this.component2D.contains(x, y);
                        }
                        case LINE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            return XYShapeQuery.this.component2D.containsLine(aX, aY, bX, bY);
                        }
                        case TRIANGLE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                            double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                            return XYShapeQuery.this.component2D.containsTriangle(aX, aY, bX, bY, cX, cY);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }

            @Override
            protected Function<byte[], Component2D.WithinRelation> contains() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double y = XYEncodingUtils.decode(scratchTriangle.aY);
                            double x = XYEncodingUtils.decode(scratchTriangle.aX);
                            return XYShapeQuery.this.component2D.withinPoint(x, y);
                        }
                        case LINE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            return XYShapeQuery.this.component2D.withinLine(aX, aY, scratchTriangle.ab, bX, bY);
                        }
                        case TRIANGLE: {
                            double aY = XYEncodingUtils.decode(scratchTriangle.aY);
                            double aX = XYEncodingUtils.decode(scratchTriangle.aX);
                            double bY = XYEncodingUtils.decode(scratchTriangle.bY);
                            double bX = XYEncodingUtils.decode(scratchTriangle.bX);
                            double cY = XYEncodingUtils.decode(scratchTriangle.cY);
                            double cX = XYEncodingUtils.decode(scratchTriangle.cX);
                            return XYShapeQuery.this.component2D.withinTriangle(aX, aY, scratchTriangle.ab, bX, bY, scratchTriangle.bc, cX, cY, scratchTriangle.ca);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + scratchTriangle.type + "]");
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.geometries, ((XYShapeQuery)o).geometries);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }
}

