/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.range.DoubleRange;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.RangeFacetCounts;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;

public class DoubleRangeFacetCounts
extends RangeFacetCounts {
    public DoubleRangeFacetCounts(String field, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, null, hits, ranges);
    }

    public DoubleRangeFacetCounts(String field, DoubleValuesSource valueSource, FacetsCollector hits, DoubleRange ... ranges) throws IOException {
        this(field, valueSource, hits, (Query)null, ranges);
    }

    public DoubleRangeFacetCounts(String field, DoubleValuesSource valueSource, FacetsCollector hits, Query fastMatchQuery, DoubleRange ... ranges) throws IOException {
        super(field, ranges, fastMatchQuery);
        if (valueSource != null) {
            this.count(valueSource, hits.getMatchingDocs());
        } else {
            this.count(field, hits.getMatchingDocs());
        }
    }

    private void count(DoubleValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        LongRange[] longRanges = this.getLongRanges();
        LongRangeCounter counter = LongRangeCounter.create(longRanges, this.counts);
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            DoubleValues fv = valueSource.getValues(hits.context, null);
            this.totCount += hits.totalHits;
            DocIdSetIterator it = this.createIterator(hits);
            if (it == null) continue;
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    counter.addSingleValued(NumericUtils.doubleToSortableLong(fv.doubleValue()));
                } else {
                    ++missingCount;
                }
                doc = it.nextDoc();
            }
        }
        this.totCount -= (missingCount += counter.finish());
    }

    @Override
    protected LongRange[] getLongRanges() {
        DoubleRange[] ranges = (DoubleRange[])this.ranges;
        LongRange[] longRanges = new LongRange[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            DoubleRange range = ranges[i];
            longRanges[i] = new LongRange(range.label, NumericUtils.doubleToSortableLong(range.min), true, NumericUtils.doubleToSortableLong(range.max), true);
        }
        return longRanges;
    }

    @Override
    protected long mapDocValue(long l) {
        return NumericUtils.sortableDoubleBits(l);
    }
}

