/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;

public class DefaultSortedSetDocValuesReaderState
extends SortedSetDocValuesReaderState {
    private final String field;
    private final int valueCount;
    public final IndexReader reader;
    private final Map<String, OrdinalMap> cachedOrdMaps = new HashMap<String, OrdinalMap>();
    private final Map<String, SortedSetDocValuesReaderState.OrdRange> prefixToOrdRange = new HashMap<String, SortedSetDocValuesReaderState.OrdRange>();

    public DefaultSortedSetDocValuesReaderState(IndexReader reader) throws IOException {
        this(reader, "$facets");
    }

    public DefaultSortedSetDocValuesReaderState(IndexReader reader, String field) throws IOException {
        this.field = field;
        this.reader = reader;
        SortedSetDocValues dv = this.getDocValues();
        if (dv == null) {
            throw new IllegalArgumentException("field \"" + field + "\" was not indexed with SortedSetDocValues");
        }
        if (dv.getValueCount() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can only handle valueCount < Integer.MAX_VALUE; got " + dv.getValueCount());
        }
        this.valueCount = (int)dv.getValueCount();
        Object lastDim = null;
        int startOrd = -1;
        for (int ord = 0; ord < this.valueCount; ++ord) {
            BytesRef term = dv.lookupOrd(ord);
            Object[] components = FacetsConfig.stringToPath(term.utf8ToString());
            if (components.length != 2) {
                throw new IllegalArgumentException("this class can only handle 2 level hierarchy (dim/value); got: " + Arrays.toString(components) + " " + term.utf8ToString());
            }
            if (components[0].equals(lastDim)) continue;
            if (lastDim != null) {
                this.prefixToOrdRange.put((String)lastDim, new SortedSetDocValuesReaderState.OrdRange(startOrd, ord - 1));
            }
            startOrd = ord;
            lastDim = components[0];
        }
        if (lastDim != null) {
            this.prefixToOrdRange.put((String)lastDim, new SortedSetDocValuesReaderState.OrdRange(startOrd, this.valueCount - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        Map<String, OrdinalMap> map = this.cachedOrdMaps;
        synchronized (map) {
            long bytes = 0L;
            for (OrdinalMap map2 : this.cachedOrdMaps.values()) {
                bytes += map2.ramBytesUsed();
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        Map<String, OrdinalMap> map = this.cachedOrdMaps;
        synchronized (map) {
            return Accountables.namedAccountables("DefaultSortedSetDocValuesReaderState", this.cachedOrdMaps);
        }
    }

    public String toString() {
        return "DefaultSortedSetDocValuesReaderState(field=" + this.field + " reader=" + this.reader + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getDocValues() throws IOException {
        OrdinalMap map = null;
        Map<String, OrdinalMap> map2 = this.cachedOrdMaps;
        synchronized (map2) {
            map = this.cachedOrdMaps.get(this.field);
            if (map == null) {
                SortedSetDocValues dv = MultiDocValues.getSortedSetValues(this.reader, this.field);
                if (dv instanceof MultiDocValues.MultiSortedSetDocValues) {
                    map = ((MultiDocValues.MultiSortedSetDocValues)dv).mapping;
                    IndexReader.CacheHelper cacheHelper = this.reader.getReaderCacheHelper();
                    if (cacheHelper != null && map.owner == cacheHelper.getKey()) {
                        this.cachedOrdMaps.put(this.field, map);
                    }
                }
                return dv;
            }
        }
        assert (map != null);
        int size = this.reader.leaves().size();
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long cost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.reader.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(this.field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(this.field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            }
            values[i] = v;
            starts[i] = context.docBase;
            cost += v.cost();
        }
        starts[size] = this.reader.maxDoc();
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map, cost);
    }

    @Override
    public Map<String, SortedSetDocValuesReaderState.OrdRange> getPrefixToOrdRange() {
        return this.prefixToOrdRange;
    }

    @Override
    public SortedSetDocValuesReaderState.OrdRange getOrdRange(String dim) {
        return this.prefixToOrdRange.get(dim);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public IndexReader getReader() {
        return this.reader;
    }

    @Override
    public int getSize() {
        return this.valueCount;
    }
}

