/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public abstract class IntTaxonomyFacets
extends TaxonomyFacets {
    private final int[] values;
    private final IntIntHashMap sparseValues;

    protected IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        if (this.useHashTable(fc, taxoReader)) {
            this.sparseValues = new IntIntHashMap();
            this.values = null;
        } else {
            this.sparseValues = null;
            this.values = new int[taxoReader.getSize()];
        }
    }

    protected boolean useHashTable(FacetsCollector fc, TaxonomyReader taxoReader) {
        if (taxoReader.getSize() < 1024) {
            return false;
        }
        if (fc == null) {
            return false;
        }
        int maxDoc = 0;
        int sumTotalHits = 0;
        for (FacetsCollector.MatchingDocs docs : fc.getMatchingDocs()) {
            sumTotalHits += docs.totalHits;
            maxDoc += docs.context.reader().maxDoc();
        }
        return sumTotalHits < maxDoc / 10;
    }

    protected void increment(int ordinal) {
        this.increment(ordinal, 1);
    }

    protected void increment(int ordinal, int amount) {
        if (this.sparseValues != null) {
            this.sparseValues.addTo(ordinal, amount);
        } else {
            int n = ordinal;
            this.values[n] = this.values[n] + amount;
        }
    }

    protected int getValue(int ordinal) {
        if (this.sparseValues != null) {
            return this.sparseValues.get(ordinal);
        }
        return this.values[ordinal];
    }

    protected void rollup() throws IOException {
        int[] children = null;
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            int dimRootOrd;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued || (dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim))) <= 0) continue;
            if (children == null) {
                children = this.getChildren();
            }
            this.increment(dimRootOrd, this.rollup(children[dimRootOrd]));
        }
    }

    private int rollup(int ord) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int sum = 0;
        while (ord != -1) {
            this.increment(ord, this.rollup(children[ord]));
            sum += this.getValue(ord);
            ord = siblings[ord];
        }
        return sum;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return this.getValue(ord);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        TopOrdAndIntQueue q = new TopOrdAndIntQueue(Math.min(this.taxoReader.getSize(), topN));
        int bottomValue = 0;
        int totValue = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        if (this.sparseValues != null) {
            for (IntIntCursor c : this.sparseValues) {
                int count = c.value;
                int ord = c.key;
                if (this.parents[ord] != dimOrd || count <= 0) continue;
                totValue += count;
                ++childCount;
                if (count <= bottomValue) continue;
                if (reuse == null) {
                    reuse = new TopOrdAndIntQueue.OrdAndValue();
                }
                reuse.ord = ord;
                reuse.value = count;
                reuse = q.insertWithOverflow(reuse);
                if (q.size() != topN) continue;
                bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
            }
        } else {
            int[] children = this.getChildren();
            int[] siblings = this.getSiblings();
            int ord = children[dimOrd];
            while (ord != -1) {
                int value = this.values[ord];
                if (value > 0) {
                    totValue += value;
                    ++childCount;
                    if (value > bottomValue) {
                        if (reuse == null) {
                            reuse = new TopOrdAndIntQueue.OrdAndValue();
                        }
                        reuse.ord = ord;
                        reuse.value = value;
                        reuse = q.insertWithOverflow(reuse);
                        if (q.size() == topN) {
                            bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
                        }
                    }
                }
                ord = siblings[ord];
            }
        }
        if (totValue == 0) {
            return null;
        }
        if (dimConfig.multiValued) {
            totValue = dimConfig.requireDimCount ? this.getValue(dimOrd) : -1;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        int[] values = new int[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.value;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[cp.length], values[i]);
        }
        return new FacetResult(dim, path, totValue, labelValues, childCount);
    }
}

