/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    public Query getWrappedQuery() {
        return this.in;
    }

    public DoubleValuesSource getSource() {
        return this.source;
    }

    public static FunctionScoreQuery boostByValue(Query in, DoubleValuesSource boost) {
        return new FunctionScoreQuery(in, new MultiplicativeBoostValuesSource(boost));
    }

    public static FunctionScoreQuery boostByQuery(Query in, Query boostMatch, float boostValue) {
        return new FunctionScoreQuery(in, new MultiplicativeBoostValuesSource(new QueryBoostValuesSource(DoubleValuesSource.fromQuery(boostMatch), boostValue)));
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ScoreMode sm = scoreMode.needsScores() && this.source.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
        Weight inner = this.in.createWeight(searcher, sm, 1.0f);
        if (!scoreMode.needsScores()) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source.rewrite(searcher), boost);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)o;
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class QueryBoostValuesSource
    extends DoubleValuesSource {
        private final DoubleValuesSource query;
        private final float boost;

        QueryBoostValuesSource(DoubleValuesSource query, float boost) {
            this.query = query;
            this.boost = boost;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final DoubleValues in = this.query.getValues(ctx, null);
            return DoubleValues.withDefault(new DoubleValues(){

                @Override
                public double doubleValue() {
                    return boost;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            }, 1.0);
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return new QueryBoostValuesSource(this.query.rewrite(reader), this.boost);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryBoostValuesSource that = (QueryBoostValuesSource)o;
            return Float.compare(that.boost, this.boost) == 0 && Objects.equals(this.query, that.query);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.query, Float.valueOf(this.boost));
        }

        @Override
        public String toString() {
            return "queryboost(" + this.query + ")^" + this.boost;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.query.isCacheable(ctx);
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            Explanation inner = this.query.explain(ctx, docId, scoreExplanation);
            if (!inner.isMatch()) {
                return inner;
            }
            return Explanation.match((Number)Float.valueOf(this.boost), "Matched boosting query " + this.query.toString(), new Explanation[0]);
        }
    }

    static class MultiplicativeBoostValuesSource
    extends DoubleValuesSource {
        final DoubleValuesSource boost;

        private MultiplicativeBoostValuesSource(DoubleValuesSource boost) {
            this.boost = boost;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            final DoubleValues in = DoubleValues.withDefault(this.boost.getValues(ctx, scores), 1.0);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return scores.doubleValue() * in.doubleValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return in.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
            return new MultiplicativeBoostValuesSource(this.boost.rewrite(reader));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiplicativeBoostValuesSource that = (MultiplicativeBoostValuesSource)o;
            return Objects.equals(this.boost, that.boost);
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            if (!scoreExplanation.isMatch()) {
                return scoreExplanation;
            }
            Explanation boostExpl = this.boost.explain(ctx, docId, scoreExplanation);
            if (!boostExpl.isMatch()) {
                return scoreExplanation;
            }
            return Explanation.match((Number)(scoreExplanation.getValue().doubleValue() * boostExpl.getValue().doubleValue()), "product of:", scoreExplanation, boostExpl);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.boost);
        }

        @Override
        public String toString() {
            return "boost(" + this.boost.toString() + ")";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.boost.isCacheable(ctx);
        }
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        final float boost;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource, float boost) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
            this.boost = boost;
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return this.inner.matches(context, doc);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation expl;
            double value;
            Explanation scoreExplanation = this.inner.explain(context, doc);
            if (!scoreExplanation.isMatch()) {
                return scoreExplanation;
            }
            Scorer scorer = this.inner.scorer(context);
            DoubleValues values = this.valueSource.getValues(context, DoubleValuesSource.fromScorer(scorer));
            int advanced = scorer.iterator().advance(doc);
            assert (advanced == doc);
            if (values.advanceExact(doc)) {
                value = values.doubleValue();
                expl = this.valueSource.explain(context, doc, scoreExplanation);
                if (value < 0.0) {
                    value = 0.0;
                    expl = Explanation.match((Number)0, "truncated score, max of:", Explanation.match((Number)Float.valueOf(0.0f), "minimum score", new Explanation[0]), expl);
                } else if (Double.isNaN(value)) {
                    value = 0.0;
                    expl = Explanation.match((Number)0, "score, computed as (score == NaN ? 0 : score) since NaN is an illegal score from:", expl);
                }
            } else {
                value = 0.0;
                expl = this.valueSource.explain(context, doc, scoreExplanation);
            }
            expl = !expl.isMatch() ? Explanation.match((Number)Float.valueOf(0.0f), "weight(" + this.getQuery().toString() + ") using default score of 0 because the function produced no value:", expl) : (this.boost != 1.0f ? Explanation.match((Number)Float.valueOf((float)(value * (double)this.boost)), "weight(" + this.getQuery().toString() + "), product of:", Explanation.match((Number)Float.valueOf(this.boost), "boost", new Explanation[0]), expl) : Explanation.match(expl.getValue(), "weight(" + this.getQuery().toString() + "), result of:", expl));
            return expl;
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer(in));
            return new FilterScorer(in){

                @Override
                public float score() throws IOException {
                    double factor;
                    if (scores.advanceExact(this.docID()) && (factor = scores.doubleValue()) >= 0.0) {
                        return (float)(factor * (double)boost);
                    }
                    return 0.0f;
                }

                @Override
                public float getMaxScore(int upTo) throws IOException {
                    return Float.POSITIVE_INFINITY;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx) && this.valueSource.isCacheable(ctx);
        }
    }
}

