/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;

class ConjunctionMatchesIterator
implements IntervalMatchesIterator {
    final IntervalIterator iterator;
    final List<? extends IntervalMatchesIterator> subs;
    boolean cached = true;

    ConjunctionMatchesIterator(IntervalIterator iterator, List<? extends IntervalMatchesIterator> subs) {
        this.iterator = iterator;
        this.subs = subs;
    }

    @Override
    public boolean next() throws IOException {
        if (this.cached) {
            this.cached = false;
            return true;
        }
        return this.iterator.nextInterval() != Integer.MAX_VALUE;
    }

    @Override
    public int startPosition() {
        return this.iterator.start();
    }

    @Override
    public int endPosition() {
        return this.iterator.end();
    }

    @Override
    public int startOffset() throws IOException {
        int start = Integer.MAX_VALUE;
        for (MatchesIterator matchesIterator : this.subs) {
            start = Math.min(start, matchesIterator.startOffset());
        }
        return start;
    }

    @Override
    public int endOffset() throws IOException {
        int end = -1;
        for (MatchesIterator matchesIterator : this.subs) {
            end = Math.max(end, matchesIterator.endOffset());
        }
        return end;
    }

    @Override
    public MatchesIterator getSubMatches() throws IOException {
        ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
        for (MatchesIterator matchesIterator : this.subs) {
            MatchesIterator sub = matchesIterator.getSubMatches();
            if (sub == null) {
                sub = new SingletonMatchesIterator(matchesIterator);
            }
            subMatches.add(sub);
        }
        return MatchesUtils.disjunction(subMatches);
    }

    @Override
    public Query getQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int gaps() {
        return this.iterator.gaps();
    }

    @Override
    public int width() {
        return this.iterator.width();
    }

    static class SingletonMatchesIterator
    extends FilterMatchesIterator {
        boolean exhausted = false;

        SingletonMatchesIterator(MatchesIterator in) {
            super(in);
        }

        @Override
        public boolean next() {
            if (this.exhausted) {
                return false;
            }
            this.exhausted = true;
            return true;
        }
    }
}

