/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;

final class GlobalOrdinalsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(GlobalOrdinalsQuery.class);
    private final LongBitSet foundOrds;
    private final String joinField;
    private final OrdinalMap globalOrds;
    private final Query toQuery;
    private final Query fromQuery;
    private final Object indexReaderContextId;
    private final long ramBytesUsed;

    GlobalOrdinalsQuery(LongBitSet foundOrds, String joinField, OrdinalMap globalOrds, Query toQuery, Query fromQuery, Object indexReaderContextId) {
        this.foundOrds = foundOrds;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.fromQuery = fromQuery;
        this.indexReaderContextId = indexReaderContextId;
        this.ramBytesUsed = BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.foundOrds) + RamUsageEstimator.sizeOfObject(this.globalOrds) + RamUsageEstimator.sizeOfObject(this.joinField) + RamUsageEstimator.sizeOfObject(this.fromQuery, 1024L) + RamUsageEstimator.sizeOfObject(this.toQuery, 1024L);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (searcher.getTopReaderContext().id() != this.indexReaderContextId) {
            throw new IllegalStateException("Creating the weight against a different index reader than this query has been built for.");
        }
        return new W(this, this.toQuery.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, 1.0f), boost);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GlobalOrdinalsQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(GlobalOrdinalsQuery other) {
        return this.fromQuery.equals(other.fromQuery) && this.joinField.equals(other.joinField) && this.toQuery.equals(other.toQuery) && this.indexReaderContextId.equals(other.indexReaderContextId);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.indexReaderContextId.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + "}";
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final LongBitSet foundOrds;

        public SegmentOrdinalScorer(Weight weight, float score, LongBitSet foundOrds, SortedDocValues values, DocIdSetIterator approximationScorer) {
            super(weight, values, approximationScorer);
            this.score = score;
            this.foundOrds = foundOrds;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    return values.advanceExact(this.approximation.docID()) && foundOrds.get(values.ordValue());
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongBitSet foundOrds;
        final LongValues segmentOrdToGlobalOrdLookup;

        public OrdinalMapScorer(Weight weight, float score, LongBitSet foundOrds, SortedDocValues values, DocIdSetIterator approximationScorer, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximationScorer);
            this.score = score;
            this.foundOrds = foundOrds;
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    long segmentOrd;
                    long globalOrd;
                    return values.advanceExact(this.approximation.docID()) && foundOrds.get(globalOrd = segmentOrdToGlobalOrdLookup.get(segmentOrd = (long)values.ordValue()));
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    final class W
    extends ConstantScoreWeight {
        private final Weight approximationWeight;

        W(Query query, Weight approximationWeight, float boost) {
            super(query, boost);
            this.approximationWeight = approximationWeight;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsQuery.this.joinField);
            if (values == null) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            if (values.advance(doc) != doc) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            int segmentOrd = values.ordValue();
            BytesRef joinValue = values.lookupOrd(segmentOrd);
            int ord = GlobalOrdinalsQuery.this.globalOrds != null ? (int)GlobalOrdinalsQuery.this.globalOrds.getGlobalOrds(context.ord).get(segmentOrd) : segmentOrd;
            if (!GlobalOrdinalsQuery.this.foundOrds.get(ord)) {
                return Explanation.noMatch("Not a match, join value " + Term.toString(joinValue), new Explanation[0]);
            }
            return Explanation.match((Number)Float.valueOf(this.score()), "A match, join value " + Term.toString(joinValue), new Explanation[0]);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            SortedDocValues values = DocValues.getSorted(context.reader(), GlobalOrdinalsQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.approximationWeight.scorer(context);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsQuery.this.globalOrds != null) {
                return new OrdinalMapScorer(this, this.score(), GlobalOrdinalsQuery.this.foundOrds, values, approximationScorer.iterator(), GlobalOrdinalsQuery.this.globalOrds.getGlobalOrds(context.ord));
            }
            return new SegmentOrdinalScorer(this, this.score(), GlobalOrdinalsQuery.this.foundOrds, values, approximationScorer.iterator());
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

