/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import org.apache.lucene.util.LongHeap;
import org.apache.lucene.util.NumericUtils;

public class NeighborQueue {
    private final LongHeap heap;
    private int visitedCount;

    NeighborQueue(int initialSize, boolean reversed) {
        this.heap = reversed ? LongHeap.create(LongHeap.Order.MAX, initialSize) : LongHeap.create(LongHeap.Order.MIN, initialSize);
    }

    public int size() {
        return this.heap.size();
    }

    public void add(int newNode, float newScore) {
        this.heap.push(this.encode(newNode, newScore));
    }

    public boolean insertWithOverflow(int newNode, float newScore) {
        return this.heap.insertWithOverflow(this.encode(newNode, newScore));
    }

    private long encode(int node, float score) {
        return (long)NumericUtils.floatToSortableInt(score) << 32 | (long)node;
    }

    public int pop() {
        return (int)this.heap.pop();
    }

    int[] nodes() {
        int size = this.size();
        int[] nodes = new int[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = (int)this.heap.get(i + 1);
        }
        return nodes;
    }

    public int topNode() {
        return (int)this.heap.top();
    }

    public float topScore() {
        return NumericUtils.sortableIntToFloat((int)(this.heap.top() >> 32));
    }

    public int visitedCount() {
        return this.visitedCount;
    }

    void setVisitedCount(int visitedCount) {
        this.visitedCount = visitedCount;
    }

    public String toString() {
        return "Neighbors[" + this.heap.size() + "]";
    }
}

