/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2x;

import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2x.JDBCConnection;
import SQLite.JDBC2x.JDBCResultSet;
import SQLite.JDBC2x.JDBCStatement;
import SQLite.JDBC2x.TableResultX;
import SQLite.Shell;
import SQLite.TableResult;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class JDBCDatabaseMetaData
implements DatabaseMetaData {
    private JDBCConnection conn;

    public JDBCDatabaseMetaData(JDBCConnection jDBCConnection) {
        this.conn = jDBCConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.conn.url;
    }

    public String getUserName() throws SQLException {
        return "";
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "SQLite";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return Database.version();
    }

    public String getDriverName() throws SQLException {
        return "SQLite/JDBC";
    }

    public String getDriverVersion() throws SQLException {
        return "1.20140624";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 20140624;
    }

    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "SELECT,UPDATE,CREATE,TABLE,VIEW,DELETE,FROM,WHERE,COMMIT,ROLLBACK,TRIGGER";
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 8;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return n == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        return null;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        JDBCStatement jDBCStatement = new JDBCStatement(this.conn);
        StringBuffer stringBuffer = new StringBuffer("SELECT '' AS 'TABLE_CAT', '' AS 'TABLE_SCHEM', tbl_name AS 'TABLE_NAME', upper(type) AS 'TABLE_TYPE', '' AS REMARKS FROM sqlite_master WHERE tbl_name like ");
        if (string3 != null) {
            stringBuffer.append(Shell.sql_quote(string3));
        } else {
            stringBuffer.append("'%'");
        }
        stringBuffer.append(" AND ");
        if (stringArray == null || stringArray.length == 0) {
            stringBuffer.append("(type = 'table' or type = 'view')");
        } else {
            stringBuffer.append("(");
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append((String)object);
                stringBuffer.append("type = ");
                stringBuffer.append(Shell.sql_quote(stringArray[i].toLowerCase()));
                object = " or ";
            }
            stringBuffer.append(")");
        }
        object = null;
        try {
            object = jDBCStatement.executeQuery(stringBuffer.toString());
            jDBCStatement.close();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            jDBCStatement.close();
        }
        return object;
    }

    public ResultSet getSchemas() throws SQLException {
        String[] stringArray = new String[]{"TABLE_SCHEM"};
        TableResult tableResult = new TableResult();
        tableResult.columns(stringArray);
        String[] stringArray2 = new String[]{""};
        tableResult.newrow(stringArray2);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResult, null);
        return jDBCResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT"};
        TableResult tableResult = new TableResult();
        tableResult.columns(stringArray);
        String[] stringArray2 = new String[]{""};
        tableResult.newrow(stringArray2);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResult, null);
        return jDBCResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] stringArray = new String[]{"TABLE_TYPE"};
        TableResult tableResult = new TableResult();
        tableResult.columns(stringArray);
        String[] stringArray2 = new String[]{"TABLE"};
        tableResult.newrow(stringArray2);
        stringArray2 = new String[]{"VIEW"};
        tableResult.newrow(stringArray2);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResult, null);
        return jDBCResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (this.conn.db == null) {
            throw new SQLException("connection closed");
        }
        JDBCStatement jDBCStatement = new JDBCStatement(this.conn);
        JDBCResultSet jDBCResultSet = null;
        try {
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception exception) {
                throw new SQLException("schema reload failed: " + exception.toString());
            }
            jDBCResultSet = (JDBCResultSet)jDBCStatement.executeQuery("PRAGMA table_info(" + Shell.sql_quote(string3) + ")");
            jDBCStatement.close();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            jDBCStatement.close();
        }
        if (jDBCResultSet.tr.nrows < 1) {
            throw new SQLException("no such table: " + string3);
        }
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
        int[] nArray = new int[]{12, 12, 12, 12, 5, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet2 = new JDBCResultSet(tableResultX, null);
        if (jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0) {
            int n;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (n = 0; n < jDBCResultSet.tr.ncolumns; ++n) {
                hashtable.put(jDBCResultSet.tr.column[n], new Integer(n));
            }
            if (string4 != null && string4.charAt(0) == '%') {
                string4 = null;
            }
            for (n = 0; n < jDBCResultSet.tr.nrows; ++n) {
                String[] stringArray2 = (String[])jDBCResultSet.tr.rows.elementAt(n);
                int n2 = (Integer)hashtable.get("name");
                if (string4 != null && stringArray2[n2].compareTo(string4) != 0) continue;
                String[] stringArray3 = new String[stringArray.length];
                stringArray3[0] = "";
                stringArray3[1] = "";
                stringArray3[2] = string3;
                stringArray3[3] = stringArray2[n2];
                n2 = (Integer)hashtable.get("type");
                String string5 = stringArray2[n2];
                int n3 = JDBCDatabaseMetaData.mapSqlType(string5);
                stringArray3[4] = "" + n3;
                stringArray3[5] = JDBCDatabaseMetaData.mapTypeName(n3);
                stringArray3[6] = "" + JDBCDatabaseMetaData.getD(string5, n3);
                stringArray3[7] = "" + JDBCDatabaseMetaData.getM(string5, n3);
                stringArray3[8] = "10";
                stringArray3[9] = "0";
                stringArray3[11] = null;
                n2 = (Integer)hashtable.get("dflt_value");
                stringArray3[12] = stringArray2[n2];
                stringArray3[13] = "0";
                stringArray3[14] = "0";
                stringArray3[15] = "65536";
                n2 = (Integer)hashtable.get("cid");
                Integer n4 = new Integer(stringArray2[n2]);
                stringArray3[16] = "" + (n4 + 1);
                n2 = (Integer)hashtable.get("notnull");
                stringArray3[17] = stringArray2[n2].charAt(0) == '0' ? "YES" : "NO";
                stringArray3[10] = stringArray2[n2].charAt(0) == '0' ? "1" : "0";
                tableResultX.newrow(stringArray3);
            }
        }
        return jDBCResultSet2;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResultX, null);
        return jDBCResultSet;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResultX, null);
        return jDBCResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Object object;
        JDBCStatement jDBCStatement = new JDBCStatement(this.conn);
        JDBCResultSet jDBCResultSet = null;
        JDBCStatement jDBCStatement2 = new JDBCStatement(this.conn);
        JDBCResultSet jDBCResultSet2 = null;
        try {
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception exception) {
                throw new SQLException("schema reload failed: " + exception.toString());
            }
            jDBCResultSet = (JDBCResultSet)jDBCStatement.executeQuery("PRAGMA index_list(" + Shell.sql_quote(string3) + ")");
            jDBCResultSet2 = (JDBCResultSet)jDBCStatement2.executeQuery("PRAGMA table_info(" + Shell.sql_quote(string3) + ")");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            jDBCStatement.close();
            jDBCStatement2.close();
        }
        String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] nArray = new int[]{5, 12, 5, 12, 4, 4, 5, 5};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet3 = new JDBCResultSet(tableResultX, null);
        if (jDBCResultSet != null && jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0 && jDBCResultSet2 != null && jDBCResultSet2.tr != null && jDBCResultSet2.tr.nrows > 0) {
            int n2;
            object = new Hashtable();
            for (int i = 0; i < jDBCResultSet.tr.ncolumns; ++i) {
                ((Hashtable)object).put(jDBCResultSet.tr.column[i], new Integer(i));
            }
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (n2 = 0; n2 < jDBCResultSet2.tr.ncolumns; ++n2) {
                hashtable.put(jDBCResultSet2.tr.column[n2], new Integer(n2));
            }
            for (n2 = 0; n2 < jDBCResultSet.tr.nrows; ++n2) {
                int n3;
                String[] stringArray2 = (String[])jDBCResultSet.tr.rows.elementAt(n2);
                int n4 = (Integer)((Hashtable)object).get("unique");
                String string4 = stringArray2[n4];
                n4 = (Integer)((Hashtable)object).get("name");
                String string5 = stringArray2[n4];
                if (string4.charAt(0) == '0') continue;
                JDBCStatement jDBCStatement3 = new JDBCStatement(this.conn);
                JDBCResultSet jDBCResultSet4 = null;
                try {
                    jDBCResultSet4 = (JDBCResultSet)jDBCStatement3.executeQuery("PRAGMA index_info(" + Shell.sql_quote(string5) + ")");
                }
                catch (SQLException sQLException) {
                }
                finally {
                    jDBCStatement3.close();
                }
                if (jDBCResultSet4 == null || jDBCResultSet4.tr == null || jDBCResultSet4.tr.nrows <= 0) continue;
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                for (n3 = 0; n3 < jDBCResultSet4.tr.ncolumns; ++n3) {
                    hashtable2.put(jDBCResultSet4.tr.column[n3], new Integer(n3));
                }
                for (n3 = 0; n3 < jDBCResultSet4.tr.nrows; ++n3) {
                    String[] stringArray3 = (String[])jDBCResultSet4.tr.rows.elementAt(n3);
                    n4 = (Integer)hashtable2.get("name");
                    String string6 = stringArray3[n4];
                    for (int i = 0; i < jDBCResultSet2.tr.nrows; ++i) {
                        String[] stringArray4 = (String[])jDBCResultSet2.tr.rows.elementAt(i);
                        if (string6.compareTo(stringArray4[n4 = ((Integer)hashtable.get("name")).intValue()]) != 0) continue;
                        String[] stringArray5 = new String[stringArray.length];
                        stringArray5[0] = "" + n;
                        stringArray5[1] = string6;
                        stringArray5[2] = "12";
                        stringArray5[3] = "VARCHAR";
                        stringArray5[4] = "65536";
                        stringArray5[5] = "0";
                        stringArray5[6] = "0";
                        stringArray5[7] = "1";
                        tableResultX.newrow(stringArray5);
                    }
                }
            }
        }
        if (tableResultX.nrows <= 0) {
            object = new String[stringArray.length];
            object[0] = "" + n;
            object[1] = "_ROWID_";
            object[2] = "4";
            object[3] = "INTEGER";
            object[4] = "10";
            object[5] = "0";
            object[6] = "0";
            object[7] = "2";
            tableResultX.newrow((String[])object);
        }
        return jDBCResultSet3;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] nArray = new int[]{5, 12, 5, 12, 4, 4, 5, 5};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResultX, null);
        return jDBCResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String[] stringArray;
        Object object;
        String string4;
        Object object2;
        JDBCStatement jDBCStatement = new JDBCStatement(this.conn);
        JDBCResultSet jDBCResultSet = null;
        try {
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception exception) {
                throw new SQLException("schema reload failed: " + exception.toString());
            }
            jDBCResultSet = (JDBCResultSet)jDBCStatement.executeQuery("PRAGMA index_list(" + Shell.sql_quote(string3) + ")");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            jDBCStatement.close();
        }
        String[] stringArray2 = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] nArray = new int[]{12, 12, 12, 12, 5, 12};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray2);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet2 = new JDBCResultSet(tableResultX, null);
        if (jDBCResultSet != null && jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0) {
            int n;
            object2 = new Hashtable();
            for (n = 0; n < jDBCResultSet.tr.ncolumns; ++n) {
                ((Hashtable)object2).put(jDBCResultSet.tr.column[n], new Integer(n));
            }
            for (n = 0; n < jDBCResultSet.tr.nrows; ++n) {
                int n2;
                String[] stringArray3 = (String[])jDBCResultSet.tr.rows.elementAt(n);
                int n3 = (Integer)((Hashtable)object2).get("unique");
                String string5 = stringArray3[n3];
                n3 = (Integer)((Hashtable)object2).get("name");
                string4 = stringArray3[n3];
                if (string5.charAt(0) == '0') continue;
                object = new JDBCStatement(this.conn);
                stringArray = null;
                try {
                    stringArray = (String[])((JDBCStatement)object).executeQuery("PRAGMA index_info(" + Shell.sql_quote(string4) + ")");
                }
                catch (SQLException sQLException) {
                }
                finally {
                    ((JDBCStatement)object).close();
                }
                if (stringArray == null || stringArray.tr == null || stringArray.tr.nrows <= 0) continue;
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                for (n2 = 0; n2 < stringArray.tr.ncolumns; ++n2) {
                    hashtable.put(stringArray.tr.column[n2], new Integer(n2));
                }
                for (n2 = 0; n2 < stringArray.tr.nrows; ++n2) {
                    String[] stringArray4 = (String[])stringArray.tr.rows.elementAt(n2);
                    String[] stringArray5 = new String[stringArray2.length];
                    stringArray5[0] = "";
                    stringArray5[1] = "";
                    stringArray5[2] = string3;
                    n3 = (Integer)hashtable.get("name");
                    stringArray5[3] = stringArray4[n3];
                    n3 = (Integer)hashtable.get("seqno");
                    stringArray5[4] = Integer.toString(Integer.parseInt(stringArray4[n3]) + 1);
                    stringArray5[5] = string4;
                    tableResultX.newrow(stringArray5);
                }
            }
        }
        if (tableResultX.nrows > 0) {
            return jDBCResultSet2;
        }
        object2 = new JDBCStatement(this.conn);
        try {
            jDBCResultSet = (JDBCResultSet)((JDBCStatement)object2).executeQuery("PRAGMA table_info(" + Shell.sql_quote(string3) + ")");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            ((JDBCStatement)object2).close();
        }
        if (jDBCResultSet != null && jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0) {
            int n;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (n = 0; n < jDBCResultSet.tr.ncolumns; ++n) {
                hashtable.put(jDBCResultSet.tr.column[n], new Integer(n));
            }
            for (n = 0; n < jDBCResultSet.tr.nrows; ++n) {
                int n4;
                String[] stringArray6 = (String[])jDBCResultSet.tr.rows.elementAt(n);
                string4 = stringArray6[n4 = ((Integer)hashtable.get("type")).intValue()];
                if (!string4.equalsIgnoreCase("integer") || ((String)(object = stringArray6[n4 = ((Integer)hashtable.get("pk")).intValue()])).charAt(0) == '0') continue;
                stringArray = new String[stringArray2.length];
                stringArray[0] = "";
                stringArray[1] = "";
                stringArray[2] = string3;
                n4 = (Integer)hashtable.get("name");
                stringArray[3] = stringArray6[n4];
                n4 = (Integer)hashtable.get("cid");
                stringArray[4] = Integer.toString(Integer.parseInt(stringArray6[n4]) + 1);
                stringArray[5] = "";
                tableResultX.newrow(stringArray);
            }
        }
        return jDBCResultSet2;
    }

    private void internalImportedKeys(String string, String string2, JDBCResultSet jDBCResultSet, TableResultX tableResultX) {
        int n;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (n = 0; n < jDBCResultSet.tr.ncolumns; ++n) {
            hashtable.put(jDBCResultSet.tr.column[n], new Integer(n));
        }
        for (n = 0; n < jDBCResultSet.tr.nrows; ++n) {
            String[] stringArray = (String[])jDBCResultSet.tr.rows.elementAt(n);
            int n2 = (Integer)hashtable.get("table");
            String string3 = stringArray[n2];
            if (string2 != null && !string2.equalsIgnoreCase(string3)) continue;
            n2 = (Integer)hashtable.get("from");
            String string4 = stringArray[n2];
            n2 = (Integer)hashtable.get("to");
            String string5 = stringArray[n2];
            n2 = (Integer)hashtable.get("seq");
            String string6 = stringArray[n2];
            String[] stringArray2 = new String[tableResultX.ncolumns];
            stringArray2[0] = "";
            stringArray2[1] = "";
            stringArray2[2] = string3;
            stringArray2[3] = string5;
            stringArray2[4] = "";
            stringArray2[5] = "";
            stringArray2[6] = string;
            stringArray2[7] = string4 == null ? string5 : string4;
            stringArray2[8] = Integer.toString(Integer.parseInt(string6) + 1);
            stringArray2[9] = "3";
            stringArray2[10] = "3";
            stringArray2[11] = null;
            stringArray2[12] = null;
            stringArray2[13] = "7";
            tableResultX.newrow(stringArray2);
        }
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        JDBCStatement jDBCStatement = new JDBCStatement(this.conn);
        JDBCResultSet jDBCResultSet = null;
        try {
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception exception) {
                throw new SQLException("schema reload failed: " + exception.toString());
            }
            jDBCResultSet = (JDBCResultSet)jDBCStatement.executeQuery("PRAGMA foreign_key_list(" + Shell.sql_quote(string3) + ")");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            jDBCStatement.close();
        }
        String[] stringArray = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet2 = new JDBCResultSet(tableResultX, null);
        if (jDBCResultSet != null && jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0) {
            this.internalImportedKeys(string3, null, jDBCResultSet, tableResultX);
        }
        return jDBCResultSet2;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResultX, null);
        return jDBCResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        String[] stringArray;
        JDBCResultSet jDBCResultSet = null;
        if (string6 != null && string6.charAt(0) != '%') {
            stringArray = new JDBCStatement(this.conn);
            try {
                try {
                    this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
                }
                catch (Exception exception) {
                    throw new SQLException("schema reload failed: " + exception.toString());
                }
                jDBCResultSet = (JDBCResultSet)stringArray.executeQuery("PRAGMA foreign_key_list(" + Shell.sql_quote(string6) + ")");
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                stringArray.close();
            }
        }
        stringArray = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet2 = new JDBCResultSet(tableResultX, null);
        if (jDBCResultSet != null && jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0) {
            String string7 = null;
            if (string3 != null && string3.charAt(0) != '%') {
                string7 = string3;
            }
            this.internalImportedKeys(string6, string7, jDBCResultSet, tableResultX);
        }
        return jDBCResultSet2;
    }

    public ResultSet getTypeInfo() throws SQLException {
        String[] stringArray = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        int[] nArray = new int[]{12, 5, 4, 12, 12, 12, 5, -7, 5, -7, -7, -7, 12, 5, 5, 4, 4, 4};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet = new JDBCResultSet(tableResultX, null);
        String[] stringArray2 = new String[]{"VARCHAR", "12", "65536", "'", "'", null, "1", "1", "3", "0", "0", "0", null, "0", "0", "0", "0", "0"};
        tableResultX.newrow(stringArray2);
        String[] stringArray3 = new String[]{"INTEGER", "4", "32", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "2"};
        tableResultX.newrow(stringArray3);
        String[] stringArray4 = new String[]{"DOUBLE", "8", "16", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "10"};
        tableResultX.newrow(stringArray4);
        String[] stringArray5 = new String[]{"FLOAT", "6", "7", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "10"};
        tableResultX.newrow(stringArray5);
        String[] stringArray6 = new String[]{"SMALLINT", "5", "16", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "2"};
        tableResultX.newrow(stringArray6);
        String[] stringArray7 = new String[]{"BIT", "-7", "1", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "2"};
        tableResultX.newrow(stringArray7);
        String[] stringArray8 = new String[]{"TIMESTAMP", "93", "30", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tableResultX.newrow(stringArray8);
        String[] stringArray9 = new String[]{"DATE", "91", "10", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tableResultX.newrow(stringArray9);
        String[] stringArray10 = new String[]{"TIME", "92", "8", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tableResultX.newrow(stringArray10);
        String[] stringArray11 = new String[]{"BINARY", "-2", "65536", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tableResultX.newrow(stringArray11);
        String[] stringArray12 = new String[]{"VARBINARY", "-3", "65536", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tableResultX.newrow(stringArray12);
        String[] stringArray13 = new String[]{"REAL", "7", "16", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "10"};
        tableResultX.newrow(stringArray13);
        return jDBCResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        JDBCStatement jDBCStatement = new JDBCStatement(this.conn);
        JDBCResultSet jDBCResultSet = null;
        try {
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception exception) {
                throw new SQLException("schema reload failed: " + exception.toString());
            }
            jDBCResultSet = (JDBCResultSet)jDBCStatement.executeQuery("PRAGMA index_list(" + Shell.sql_quote(string3) + ")");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            jDBCStatement.close();
        }
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] nArray = new int[]{12, 12, 12, -7, 12, 12, 5, 5, 12, 12, 4, 4, 12};
        TableResultX tableResultX = new TableResultX();
        tableResultX.columns(stringArray);
        tableResultX.sql_types(nArray);
        JDBCResultSet jDBCResultSet2 = new JDBCResultSet(tableResultX, null);
        if (jDBCResultSet != null && jDBCResultSet.tr != null && jDBCResultSet.tr.nrows > 0) {
            int n;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            for (n = 0; n < jDBCResultSet.tr.ncolumns; ++n) {
                hashtable.put(jDBCResultSet.tr.column[n], new Integer(n));
            }
            for (n = 0; n < jDBCResultSet.tr.nrows; ++n) {
                int n2;
                String[] stringArray2 = (String[])jDBCResultSet.tr.rows.elementAt(n);
                int n3 = (Integer)hashtable.get("unique");
                String string4 = stringArray2[n3];
                n3 = (Integer)hashtable.get("name");
                String string5 = stringArray2[n3];
                if (bl && string4.charAt(0) == '0') continue;
                JDBCStatement jDBCStatement2 = new JDBCStatement(this.conn);
                JDBCResultSet jDBCResultSet3 = null;
                try {
                    jDBCResultSet3 = (JDBCResultSet)jDBCStatement2.executeQuery("PRAGMA index_info(" + Shell.sql_quote(string5) + ")");
                }
                catch (SQLException sQLException) {
                }
                finally {
                    jDBCStatement2.close();
                }
                if (jDBCResultSet3 == null || jDBCResultSet3.tr == null || jDBCResultSet3.tr.nrows <= 0) continue;
                Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
                for (n2 = 0; n2 < jDBCResultSet3.tr.ncolumns; ++n2) {
                    hashtable2.put(jDBCResultSet3.tr.column[n2], new Integer(n2));
                }
                for (n2 = 0; n2 < jDBCResultSet3.tr.nrows; ++n2) {
                    String[] stringArray3 = (String[])jDBCResultSet3.tr.rows.elementAt(n2);
                    String[] stringArray4 = new String[stringArray.length];
                    stringArray4[0] = "";
                    stringArray4[1] = "";
                    stringArray4[2] = string3;
                    stringArray4[3] = string4.charAt(0) != '0' || string5.charAt(0) == '(' && string5.indexOf(" autoindex ") > 0 ? "0" : "1";
                    stringArray4[4] = "";
                    stringArray4[5] = string5;
                    stringArray4[6] = "3";
                    n3 = (Integer)hashtable2.get("seqno");
                    stringArray4[7] = Integer.toString(Integer.parseInt(stringArray3[n3]) + 1);
                    n3 = (Integer)hashtable2.get("name");
                    stringArray4[8] = stringArray3[n3];
                    stringArray4[9] = "A";
                    stringArray4[10] = "0";
                    stringArray4[11] = "0";
                    stringArray4[12] = null;
                    tableResultX.newrow(stringArray4);
                }
            }
        }
        return jDBCResultSet2;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003 || n == 1004 || n == 1005;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n == 1003 || n == 1004 || n == 1005) {
            return n2 == 1007 || n2 == 1008;
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return n == 1003 || n == 1004 || n == 1005;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return n == 1003 || n == 1004 || n == 1005;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return n == 1003 || n == 1004 || n == 1005;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    static String mapTypeName(int n) {
        switch (n) {
            case 4: {
                return "integer";
            }
            case 5: {
                return "smallint";
            }
            case 6: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 93: {
                return "timestamp";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case -2: {
                return "binary";
            }
            case -3: {
                return "varbinary";
            }
            case 7: {
                return "real";
            }
        }
        return "varchar";
    }

    static int mapSqlType(String string) {
        if (string == null) {
            return 12;
        }
        if ((string = string.toLowerCase()).startsWith("inter")) {
            return 12;
        }
        if (string.startsWith("numeric") || string.startsWith("int")) {
            return 4;
        }
        if (string.startsWith("tinyint") || string.startsWith("smallint")) {
            return 5;
        }
        if (string.startsWith("float")) {
            return 6;
        }
        if (string.startsWith("double")) {
            return 8;
        }
        if (string.startsWith("datetime") || string.startsWith("timestamp")) {
            return 93;
        }
        if (string.startsWith("date")) {
            return 91;
        }
        if (string.startsWith("time")) {
            return 92;
        }
        if (string.startsWith("blob")) {
            return -2;
        }
        if (string.startsWith("binary")) {
            return -2;
        }
        if (string.startsWith("varbinary")) {
            return -3;
        }
        if (string.startsWith("real")) {
            return 7;
        }
        return 12;
    }

    static int getM(String string, int n) {
        int n2 = 65536;
        switch (n) {
            case 4: {
                n2 = 11;
                break;
            }
            case 5: {
                n2 = 6;
                break;
            }
            case 6: {
                n2 = 25;
                break;
            }
            case 7: 
            case 8: {
                n2 = 54;
                break;
            }
            case 93: {
                return 30;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
        }
        string = string.toLowerCase();
        int n3 = string.indexOf(40);
        if (n3 > 0) {
            int n4;
            if ((n4 = string.indexOf(44, ++n3)) < 0) {
                n4 = string.indexOf(41, n3);
            }
            if (n4 - n3 > 0) {
                String string2 = string.substring(n3, n4);
                try {
                    n2 = Integer.parseInt(string2, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return n2;
    }

    static int getD(String string, int n) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 = 10;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 6: {
                n2 = 24;
                break;
            }
            case 7: 
            case 8: {
                n2 = 53;
                break;
            }
            default: {
                return JDBCDatabaseMetaData.getM(string, n);
            }
        }
        string = string.toLowerCase();
        int n3 = string.indexOf(40);
        if (n3 > 0) {
            int n4;
            if ((n4 = string.indexOf(44, ++n3)) < 0) {
                return JDBCDatabaseMetaData.getM(string, n);
            }
            n3 = n4;
            if ((n4 = string.indexOf(41, n3)) - n3 > 0) {
                String string2 = string.substring(n3, n4);
                try {
                    n2 = Integer.parseInt(string2, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return n2;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    public boolean supportsResultSetHoldability(int n) {
        return false;
    }

    public boolean supportsStatementPooling() {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new SQLException("not supported");
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() {
        return 1;
    }

    public int getDatabaseMinorVersion() {
        return 20140624;
    }

    public int getJDBCMajorVersion() {
        return 1;
    }

    public int getJDBCMinorVersion() {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }
}

