# GSL: Guideline Support Library [![Build Status](https://travis-ci.org/Microsoft/GSL.svg?branch=master)](https://travis-ci.org/Microsoft/GSL) [![Build status](https://ci.appveyor.com/api/projects/status/github/Microsoft/GSL?svg=true)](https://ci.appveyor.com/project/neilmacintosh/GSL)\\r\\n\\r\\nThe Guideline Support Library (GSL) contains functions and types that are suggested for use by the\\r\\n[C++ Core Guidelines](https://github.com/isocpp/CppCoreGuidelines) maintained by the [Standard C++ Foundation](https://isocpp.org).\\r\\nThis repo contains Microsoft's implementation of GSL.\\r\\n\\r\\nThe library includes types like `span<T>`, `string_span`, `owner<>` and others.\\r\\n\\r\\nThe entire implementation is provided inline in the headers under the [gsl](./include/gsl) directory. The implementation generally assumes a platform that implements C++14 support. There are specific workarounds to support MSVC 2013 and 2015.\\r\\n\\r\\nWhile some types have been broken out into their own headers (e.g. [gsl/span](./include/gsl/span)),\\r\\nit is simplest to just include [gsl/gsl](./include/gsl/gsl) and gain access to the entire library.\\r\\n\\r\\n> NOTE: We encourage contributions that improve or refine any of the types in this library as well as ports to\\r\\nother platforms. Please see [CONTRIBUTING.md](./CONTRIBUTING.md) for more information about contributing.\\r\\n\\r\\n# Project Code of Conduct\\r\\nThis project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/). For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.\\r\\n\\r\\n# Quick Start\\r\\n## Supported Platforms\\r\\nThe test suite that exercises GSL has been built and passes successfully on the following platforms:<sup>1)</sup>\\r\\n\\r\\n* Windows using Visual Studio 2015\\r\\n* Windows using Visual Studio 2017\\r\\n* Windows using Clang/LLVM 3.6\\r\\n* Windows using GCC 5.1\\r\\n* GNU/Linux using Clang/LLVM 3.6\\r\\n* GNU/Linux using GCC 5.1\\r\\n* OS X Yosemite using Xcode with AppleClang 7.0.0.7000072\\r\\n* OS X Yosemite using GCC-5.2.0\\r\\n* FreeBSD 10.x with Clang/LLVM 3.6\\r\\n\\r\\n> If you successfully port GSL to another platform, we would love to hear from you. Please submit an issue to let us know. Also please consider\\r\\ncontributing any changes that were necessary back to this project to benefit the wider community.\\r\\n\\r\\n<sup>1)</sup> For `gsl::byte` to work correctly with Clang and GCC you might have to use the ` -fno-strict-aliasing` compiler option.\\r\\n\\r\\n## Building the tests\\r\\nTo build the tests, you will require the following:\\r\\n\\r\\n* [CMake](http://cmake.org), version 2.8.7 or later to be installed and in your PATH.\\r\\n* [UnitTest-cpp](https://github.com/Microsoft/unittest-cpp), to be cloned under the [tests/unittest-cpp](./tests/unittest-cpp) directory\\r\\nof your GSL source.\\r\\n\\r\\nThese steps assume the source code of this repository has been cloned into a directory named `c:\\\\GSL`.\\r\\n\\r\\n1. Create a directory to contain the build outputs for a particular architecture (we name it c:\\\\GSL\\\\build-x86 in this example).\\r\\n\\r\\n        cd GSL\\r\\n        md build-x86\\r\\n        cd build-x86\\r\\n\\r\\n2. Configure CMake to use the compiler of your choice (you can see a list by running `cmake --help`).\\r\\n\\r\\n        cmake -G \\\"Visual Studio 14 2015\\\" c:\\\\GSL\\r\\n\\r\\n3. Build the test suite (in this case, in the Debug configuration, Release is another good choice).    \\r\\n\\r\\n        cmake --build . --config Debug\\r\\n\\r\\n4. Run the test suite.    \\r\\n\\r\\n        ctest -C Debug\\r\\n\\r\\nAll tests should pass - indicating your platform is fully supported and you are ready to use the GSL types!\\r\\n\\r\\n## Using the libraries\\r\\nAs the types are entirely implemented inline in headers, there are no linking requirements.\\r\\n\\r\\nYou can copy the [gsl](./include/gsl) directory into your source tree so it is available\\r\\nto your compiler, then include the appropriate headers in your program.\\r\\n\\r\\nAlternatively set your compiler's *include path* flag to point to the GSL development folder (`c:\\\\GSL\\\\include` in the example above) or installation folder (after running the install). Eg.\\r\\n\\r\\nMSVC++\\r\\n\\r\\n    /I c:\\\\GSL\\\\include\\r\\n\\r\\nGCC/clang\\r\\n\\r\\n    -I$HOME/dev/GSL/include\\r\\n\\r\\nInclude the library using:\\r\\n\\r\\n    #include <gsl/gsl>\\r\\n\\r\\n## Debugging visualization support\\r\\nFor Visual Studio users, the file [GSL.natvis](./GSL.natvis) in the root directory of the repository can be added to your project if you would like more helpful visualization of GSL types in the Visual Studio debugger than would be offered by default.\\r\\n