<p align=\\\"center\\\"><img src=\\\"https://raw.githubusercontent.com/facebook/zstd/dev/doc/images/zstd_logo86.png\\\" alt=\\\"Zstandard\\\"></p>\\n\\n__Zstandard__, or `zstd` as short version, is a fast lossless compression algorithm,\\ntargeting real-time compression scenarios at zlib-level and better compression ratios.\\nIt's backed by a very fast entropy stage, provided by [Huff0 and FSE library](https://github.com/Cyan4973/FiniteStateEntropy).\\n\\nThe project is provided as an open-source dual [BSD](LICENSE) and [GPLv2](COPYING) licensed **C** library,\\nand a command line utility producing and decoding `.zst`, `.gz`, `.xz` and `.lz4` files.\\nShould your project require another programming language,\\na list of known ports and bindings is provided on [Zstandard homepage](http://www.zstd.net/#other-languages).\\n\\n**Development branch status:**\\n\\n[![Build Status][travisDevBadge]][travisLink]\\n[![Build status][AppveyorDevBadge]][AppveyorLink]\\n[![Build status][CircleDevBadge]][CircleLink]\\n[![Build status][CirrusDevBadge]][CirrusLink]\\n[![Fuzzing Status][OSSFuzzBadge]][OSSFuzzLink]\\n\\n[travisDevBadge]: https://travis-ci.org/facebook/zstd.svg?branch=dev \\\"Continuous Integration test suite\\\"\\n[travisLink]: https://travis-ci.org/facebook/zstd\\n[AppveyorDevBadge]: https://ci.appveyor.com/api/projects/status/xt38wbdxjk5mrbem/branch/dev?svg=true \\\"Windows test suite\\\"\\n[AppveyorLink]: https://ci.appveyor.com/project/YannCollet/zstd-p0yf0\\n[CircleDevBadge]: https://circleci.com/gh/facebook/zstd/tree/dev.svg?style=shield \\\"Short test suite\\\"\\n[CircleLink]: https://circleci.com/gh/facebook/zstd\\n[CirrusDevBadge]: https://api.cirrus-ci.com/github/facebook/zstd.svg?branch=dev\\n[CirrusLink]: https://cirrus-ci.com/github/facebook/zstd\\n[OSSFuzzBadge]: https://oss-fuzz-build-logs.storage.googleapis.com/badges/zstd.svg\\n[OSSFuzzLink]: https://bugs.chromium.org/p/oss-fuzz/issues/list?sort=-opened&can=1&q=proj:zstd\\n\\n## Benchmarks\\n\\nFor reference, several fast compression algorithms were tested and compared\\non a server running Arch Linux (`Linux version 5.5.11-arch1-1`),\\nwith a Core i9-9900K CPU @ 5.0GHz,\\nusing [lzbench], an open-source in-memory benchmark by @inikep\\ncompiled with [gcc] 9.3.0,\\non the [Silesia compression corpus].\\n\\n[lzbench]: https://github.com/inikep/lzbench\\n[Silesia compression corpus]: http://sun.aei.polsl.pl/~sdeor/index.php?page=silesia\\n[gcc]: https://gcc.gnu.org/\\n\\n| Compressor name         | Ratio | Compression| Decompress.|\\n| ---------------         | ------| -----------| ---------- |\\n| **zstd 1.4.5 -1**       | 2.884 |   500 MB/s |  1660 MB/s |\\n| zlib 1.2.11 -1          | 2.743 |    90 MB/s |   400 MB/s |\\n| brotli 1.0.7 -0         | 2.703 |   400 MB/s |   450 MB/s |\\n| **zstd 1.4.5 --fast=1** | 2.434 |   570 MB/s |  2200 MB/s |\\n| **zstd 1.4.5 --fast=3** | 2.312 |   640 MB/s |  2300 MB/s |\\n| quicklz 1.5.0 -1        | 2.238 |   560 MB/s |   710 MB/s |\\n| **zstd 1.4.5 --fast=5** | 2.178 |   700 MB/s |  2420 MB/s |\\n| lzo1x 2.10 -1           | 2.106 |   690 MB/s |   820 MB/s |\\n| lz4 1.9.2               | 2.101 |   740 MB/s |  4530 MB/s |\\n| **zstd 1.4.5 --fast=7** | 2.096 |   750 MB/s |  2480 MB/s |\\n| lzf 3.6 -1              | 2.077 |   410 MB/s |   860 MB/s |\\n| snappy 1.1.8            | 2.073 |   560 MB/s |  1790 MB/s |\\n\\n[zlib]: http://www.zlib.net/\\n[LZ4]: http://www.lz4.org/\\n\\nThe negative compression levels, specified with `--fast=#`,\\noffer faster compression and decompression speed in exchange for some loss in\\ncompression ratio compared to level 1, as seen in the table above.\\n\\nZstd can also offer stronger compression ratios at the cost of compression speed.\\nSpeed vs Compression trade-off is configurable by small increments.\\nDecompression speed is preserved and remains roughly the same at all settings,\\na property shared by most LZ compression algorithms, such as [zlib] or lzma.\\n\\nThe following tests were run\\non a server running Linux Debian (`Linux version 4.14.0-3-amd64`)\\nwith a Core i7-6700K CPU @ 4.0GHz,\\nusing [lzbench], an open-source in-memory benchmark by @inikep\\ncompiled with [gcc] 7.3.0,\\non the [Silesia compression corpus].\\n\\nCompression Speed vs Ratio | Decompression Speed\\n---------------------------|--------------------\\n![Compression Speed vs Ratio](doc/images/CSpeed2.png \\\"Compression Speed vs Ratio\\\") | ![Decompression Speed](doc/images/DSpeed3.png \\\"Decompression Speed\\\")\\n\\nA few other algorithms can produce higher compression ratios at slower speeds, falling outside of the graph.\\nFor a larger picture including slow modes, [click on this link](doc/images/DCspeed5.png).\\n\\n\\n## The case for Small Data compression\\n\\nPrevious charts provide results applicable to typical file and stream scenarios (several MB). Small data comes with different perspectives.\\n\\nThe smaller the amount of data to compress, the more difficult it is to compress. This problem is common to all compression algorithms, and reason is, compression algorithms learn from past data how to compress future data. But at the beginning of a new data set, there is no \\\"past\\\" to build upon.\\n\\nTo solve this situation, Zstd offers a __training mode__, which can be used to tune the algorithm for a selected type of data.\\nTraining Zstandard is achieved by providing it with a few samples (one file per sample). The result of this training is stored in a file called \\\"dictionary\\\", which must be loaded before compression and decompression.\\nUsing this dictionary, the compression ratio achievable on small data improves dramatically.\\n\\nThe following example uses the `github-users` [sample set](https://github.com/facebook/zstd/releases/tag/v1.1.3), created from [github public API](https://developer.github.com/v3/users/#get-all-users).\\nIt consists of roughly 10K records weighing about 1KB each.\\n\\nCompression Ratio | Compression Speed | Decompression Speed\\n------------------|-------------------|--------------------\\n![Compression Ratio](doc/images/dict-cr.png \\\"Compression Ratio\\\") | ![Compression Speed](doc/images/dict-cs.png \\\"Compression Speed\\\") | ![Decompression Speed](doc/images/dict-ds.png \\\"Decompression Speed\\\")\\n\\n\\nThese compression gains are achieved while simultaneously providing _faster_ compression and decompression speeds.\\n\\nTraining works if there is some correlation in a family of small data samples. The more data-specific a dictionary is, the more efficient it is (there is no _universal dictionary_).\\nHence, deploying one dictionary per type of data will provide the greatest benefits.\\nDictionary gains are mostly effective in the first few KB. Then, the compression algorithm will gradually use previously decoded content to better compress the rest of the file.\\n\\n### Dictionary compression How To:\\n\\n1. Create the dictionary\\n\\n   `zstd --train FullPathToTrainingSet/* -o dictionaryName`\\n\\n2. Compress with dictionary\\n\\n   `zstd -D dictionaryName FILE`\\n\\n3. Decompress with dictionary\\n\\n   `zstd -D dictionaryName --decompress FILE.zst`\\n\\n\\n## Build instructions\\n\\n### Makefile\\n\\nIf your system is compatible with standard `make` (or `gmake`),\\ninvoking `make` in root directory will generate `zstd` cli in root directory.\\n\\nOther available options include:\\n- `make install` : create and install zstd cli, library and man pages\\n- `make check` : create and run `zstd`, tests its behavior on local platform\\n\\n### cmake\\n\\nA `cmake` project generator is provided within `build/cmake`.\\nIt can generate Makefiles or other build scripts\\nto create `zstd` binary, and `libzstd` dynamic and static libraries.\\n\\nBy default, `CMAKE_BUILD_TYPE` is set to `Release`.\\n\\n### Meson\\n\\nA Meson project is provided within [`build/meson`](build/meson). Follow\\nbuild instructions in that directory.\\n\\nYou can also take a look at [`.travis.yml`](.travis.yml) file for an\\nexample about how Meson is used to build this project.\\n\\nNote that default build type is **release**.\\n\\n### VCPKG\\nYou can build and install zstd [vcpkg](https://github.com/Microsoft/vcpkg/) dependency manager:\\n\\n    git clone https://github.com/Microsoft/vcpkg.git\\n    cd vcpkg\\n    ./bootstrap-vcpkg.sh\\n    ./vcpkg integrate install\\n    ./vcpkg install zstd\\n\\nThe zstd port in vcpkg is kept up to date by Microsoft team members and community contributors.\\nIf the version is out of date, please [create an issue or pull request](https://github.com/Microsoft/vcpkg) on the vcpkg repository.\\n\\n### Visual Studio (Windows)\\n\\nGoing into `build` directory, you will find additional possibilities:\\n- Projects for Visual Studio 2005, 2008 and 2010.\\n  + VS2010 project is compatible with VS2012, VS2013, VS2015 and VS2017.\\n- Automated build scripts for Visual compiler by [@KrzysFR](https://github.com/KrzysFR), in `build/VS_scripts`,\\n  which will build `zstd` cli and `libzstd` library without any need to open Visual Studio solution.\\n\\n### Buck\\n\\nYou can build the zstd binary via buck by executing: `buck build programs:zstd` from the root of the repo.\\nThe output binary will be in `buck-out/gen/programs/`.\\n\\n## Testing\\n\\nYou can run quick local smoke tests by executing the `playTest.sh` script from the `src/tests` directory.\\nTwo env variables `$ZSTD_BIN` and `$DATAGEN_BIN` are needed for the test script to locate the zstd and datagen binary.\\nFor information on CI testing, please refer to TESTING.md\\n\\n## Status\\n\\nZstandard is currently deployed within Facebook. It is used continuously to compress large amounts of data in multiple formats and use cases.\\nZstandard is considered safe for production environments.\\n\\n## License\\n\\nZstandard is dual-licensed under [BSD](LICENSE) and [GPLv2](COPYING).\\n\\n## Contributing\\n\\nThe `dev` branch is the one where all contributions are merged before reaching `release`.\\nIf you plan to propose a patch, please commit into the `dev` branch, or its own feature branch.\\nDirect commit to `release` are not permitted.\\nFor more information, please read [CONTRIBUTING](CONTRIBUTING.md).\\n