/*jslint browser: true, plusplus: true */
/*global brite $ */
'use strict';

/**
 * @author psteeger
 */


(function() {

  brite.registerView('techviews_view', {

    create: function(data) {
      var view = this;

      // if /service/techviews isn't available (prior V9.08), we'll need to use techviews.vbb which listens to the prjpath parameter
      return render("tmpl-techviews_static");
    },

    postDisplay: function() {
      var view = this;

      psol.index.getTechViewsAsync({mident: '{'+main.tableData.index.path+'}', path: main.tableData.index.path}).always(function(data) {
        $.extend(techviewData, data, {title: 'Technische Ansichten', title2: 'Technische Ansicht'});

        $('#techview_container').html(render('tmpl-techviews_view', techviewData));

        if ( techviewData.views && techviewData.views.length > 0 ) {
          setTechviewSize.call(view);
          view.$el.find('.techviews_view-image').on('load', function() {
            setTechviewSize.call(view);
          });
        }
        else {
          view.$el.trigger('HIDE_TECHVIEW');
          main.hasTechviews = false;
        }

        view.$el.trigger('resize');

      });


    },

    events: {
      'click; .techviews_view-controls-right': function(event) {
        switchTechview.call(this, true);
      },

      'click; .techviews_view-controls-left': function(event) {
        switchTechview.call(this, false);
      }
    },

    winEvents: {
      'resize': function(event) {
        if ( main.hasTechviews )
          setTechviewSize.call(this);
      }
    }

  });


  var techviewData = {};


  function setTechviewSize() {
    var view = this;

    var image = view.$el.find('.techviews_view-image');
    var ratio = image.get(0).naturalWidth / image.get(0).naturalHeight;
    var maxHeight = view.$el.height() - view.$el.find('.techviews_view-title').outerHeight(true);
    var maxWidth = view.$el.width();

    var width = maxWidth;
    var height = width / ratio;

    if ( height > maxHeight ) {
      height = maxHeight;
      width = height * ratio;
    }

    view.$el.find('.techviews_view-imageBox').outerWidth(width);
    view.$el.find('.techviews_view-imageBox').outerHeight(height);
  }


  function switchTechview(isNext) {
    var view = this;

    var currentIdx = parseInt(view.$el.attr('currentIdx'));
    var viewCount = techviewData.views.length;
    if ( isNext )
      currentIdx = (currentIdx + 1 < viewCount ) ? currentIdx + 1 : 0;
    else
      currentIdx = (currentIdx - 1 >= 0 ) ? currentIdx - 1 : viewCount - 1;

    var image = view.$el.find('.techviews_view-image');
    image.attr('src', techviewData.views[currentIdx].dataUrl);
    view.$el.find('#techviewIdx').html(currentIdx + 1);
    view.$el.attr('currentIdx', currentIdx);
  }

})();
