/**
 * @namespace
 * @global
 */
window.psol = window.psol || {};

/**
 * @namespace
 * @global
 */
window.psol.components = window.psol.components || {};

(function ($) {
  'use strict';

  /**
   *
   */
  psol.components.componentsPath = '.';

  /**
   * Base class for components
   * @class
   * @memberof psol.components
   * @param {String} componentName The internal name of the view component
   */
  psol.components.Base = function (componentName) {
    this._privateProps = {
      componentName: componentName || 'UNKNOWN_VIEW'
    };

    this._props = {};
  };


  /**
   * Start a long running task.
   * The retured jQuery.Deferred object could be resolved with a custom object which is send into {@link onProgressEnd} when the task has finished
   * @param   {String}          title The title of the progress task
   * @param   {String}          text  The description of the progress task
   * @returns {jQuery.Deferred} A {@link http://api.jquery.com/category/deferred-object/ jQuery.Deferred} object, which should resolve when the progress view is rendered.
   */

  /*eslint-disable no-unused-vars*/
  psol.components.Base.prototype.onProgressBegin = function (title, text) {
    /* Base class does noting here */
    return $.Deferred().resolve();
  };
  /*eslint-enable no-unused-vars*/


  /**
   * The long running task is finished
   * @param {Object} progressCutomObject The custom object which is send through resolve in {@link onProgressBegin}
   */

  /*eslint-disable no-unused-vars*/
  psol.components.Base.prototype.onProgressEnd = function (progressCutomObject) {
    /* Base class does noting here */
    return;
  };
  /*eslint-enable no-unused-vars*/


  /**
   * Initialize the component
   * @param   {Object} settings The settings for this component
   */
  psol.components.Base.prototype.init = function (settings) {
    // apply new settings
    $.extend(this._props, settings);
    // apply private settings on it
    $.extend(this._props, this._privateProps);
  };

}(jQuery));
