var classSelector;

var saveSelectorValue = function()
{
     cnsContext.setClassification(document.getElementById("class-selector").value);
};

var hideAllClassDetails = function()
{
  var classDetails = document.getElementsByClassName("class-details");
  var i;
  for (i = 0; i < classDetails.length; i++) {
    classDetails[i].className = "class-details";
  }
}

var setSelectedClass = function( currentValue )
{
  var classDetails = document.getElementsByClassName("class-details");
  var found = false;
  var j;
  for (j = 0; j < classDetails.length; j++) {
    if (classDetails[j].title == currentValue) {
      hideAllClassDetails();
      classDetails[j].className = "class-details active";
      found = true;
      break;
    }
  }
  if(!found && classDetails.length > 0)
  {
    hideAllClassDetails();
    classDetails[0].className = "class-details active";
  }
}

var setSelectedClassHandler = function()
{
  setSelectedClass(this.value);
}

var loadClassFromContext = function()
{
  var savedValue = cnsContext.getClassification();
  if (savedValue != null && savedValue !== "")
  {
    classSelector.value = savedValue;
    setSelectedClass(savedValue);
  }
}

window.addEventListener('load', function()
{
    classSelector = document.getElementById("class-selector");
    if (classSelector)
    {
        classSelector.addEventListener('change', saveSelectorValue);
        classSelector.addEventListener('change', setSelectedClassHandler);
        
        //cnsContext not immediately after load available
        setTimeout(loadClassFromContext, 50);
    }
});
