
function fixId(id)
{
	if (id=='')
	  return -1;
    if (typeof(id)=='string')
	  return parseInt(id);
     return id;
}

function openDirectory(classification, classId)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openDirectory(classification, classId);
	}
}

function openCatalog(catalog)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openCatalog(catalog);
	}
}

function openPart(classification, classId, lineId, lineSubId)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openPart(classification, classId, fixId(lineId), fixId(lineSubId));
	}
}

function comparePart(partNumber, classification, classId, lineId, lineSubId)
{
	var form = document.getElementById('form_' + partNumber);
	if (form != null)
	{
		try
		{
			var pClassification = form.classification.value;
			var pClassId = form.classid.value;
			var pLineId = form.lineid.value;
			var pLineSubId = form.linesubid.value;
			
			if (window.pdatamanager != undefined)
			{
				pdatamanager.clearCompareParts();
				pdatamanager.comparePart(pClassification, pClassId, fixId(pLineId), fixId(pLineSubId), classification, classId, fixId(lineId), fixId(lineSubId));
			}
		}
		catch(e)
		{
		
		}
	}
}

function compareAllParts(partNumber)
{
	if (window.pdatamanager != undefined)
	{
		var form = document.getElementById('form_' + partNumber);
		if (form != null)
		{
			try
			{
				var pClassification = form.classification.value;
				var pClassId = form.classid.value;
				var pLineId = form.lineid.value;
				var pLineSubId = form.linesubid.value;
				
				pdatamanager.clearCompareParts();
				pdatamanager.addComparePart(pClassification, pClassId, fixId(pLineId), fixId(pLineSubId));
				
				var childList = form.childlist.value;
				var params = childList.split(",");
				if (params.length % 4 == 0)
				{
					for (var i = 0; i < params.length - 3; i += 4)
					{
						pdatamanager.addComparePart(params[i], params[i + 1], parseInt(params[i + 2]), parseInt(params[i + 3]));
					}
				}
				pdatamanager.showPartCompare();
			}
			catch(e)
			{
			
			}
		}
	}
}

function initReport()
{
  $('.RFPcheck').change(function() {
			var splitData = $(this).attr('rel').split(",");
			
      if (splitData.length == 4)
      {
        var classification = splitData[0];
        var classId = splitData[1];
        var lineId = splitData[2];
        var lineSubId = splitData[3];
        
        if (window.rfp != undefined)
          rfp.togglePart(classification, classId, fixId(lineId), fixId(lineSubId));
      }
	});	
  
  if (window.rfp != undefined)
  {
    $('.RFPcheck').each(function() {
      var splitData = $(this).attr('rel').split(",");
      var classification = splitData[0];
      var classid = splitData[1];
      var lineid = splitData[2];
      var linesubid = splitData[3];
      $(this).attr('checked', rfp.isPartSelected(classification, classid, fixId(lineid), fixId(linesubid)));            
    });
  }
  
  CollapseAllBlocks();
}

function CollapseAllBlocks()
{

  var params = getUrlParameters();
  var part_id = params['part_id'];
  if (part_id != undefined && part_id != "")
  {
    $('a#' + part_id).find('div.LeftPartPicContainer, div.RightPartPicContainer').addClass('highlight');
  }
  
	var  i = 1;
	while (document.getElementById('td_' + i) != null)
	{
  
    var hasSearchResult = $('#td_' + i).find('.highlight').length;
    
    if (hasSearchResult == 0) {
      CollapseSearchResults(i);
    }    
		
		i++;
	}

}

function CollapseSearchResults(partId)
{
	var td = document.getElementById('td_' + partId);
	if (td != null)
	{
		var id = '#td_' + partId;
		var i=0;
		$(id).find('.RightPartPicContainer').each(function() {
			i++;
			if (i > 3) {
				$(this).hide();	
			}
		});
		$('#less_'+partId).hide();
		$('#more_'+partId).show();
	}
}

function ExpandSearchResults(partId)
{ 	
	var td = document.getElementById('td_' + partId);
	if (td != null)
	{
		var id = '#td_' + partId;
		var i=0;
		$(id).find('.RightPartPicContainer').show();
		$('#less_'+partId).show();
		$('#more_'+partId).hide();
	}
}

function requestForPrices()
{
  if (window.rfp != undefined)
  {
    rfp.requestPrices();
  }
}

function selectPart(page, anchor)
{
  var newUrl = "html/" + page + "_sorted.html?part_id=" + anchor + "&" + new Date().getTime() + "#" + anchor;
  top.frames.content.window.location.href = newUrl;
}

function getUrlParameters()
{
    var params = []
    var hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for (var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        params.push(hash[0]);
        params[hash[0]] = hash[1];
    }
    return params;
}