
function fixId(id)
{
	if (id=='')
	  return -1;
    if (typeof(id)=='string')
	  return parseInt(id);
     return id;
}

function openDirectory(classification, classId)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openDirectory(classification, classId);
	}
}

function openCatalog(catalog)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openCatalog(catalog);
	}
}

function openPart(classification, classId, lineId, lineSubId)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openPart(classification, classId, fixId(lineId), fixId(lineSubId));
	}
}

function comparePart(partNumber, classification, classId, lineId, lineSubId, alignmentEnabled)
{
	var form = document.getElementById('form_' + partNumber);
	if (form != null)
	{
		try
		{
			var pClassification = form.classification.value;
			var pClassId = form.classid.value;
			var pLineId = form.lineid.value;
			var pLineSubId = form.linesubid.value;
			
			if (window.pdatamanager != undefined)
			{
				pdatamanager.clearCompareParts();
				pdatamanager.comparePart(classification, classId, fixId(lineId), fixId(lineSubId), pClassification, pClassId, fixId(pLineId), fixId(pLineSubId));
			        if(alignmentEnabled)
			        {
			          pdatamanager.alignAxes(true, "RawPartAlignment");
			        }
			        else
			        {
			          pdatamanager.moveToOrigPos();
			        }
			}
		}
		catch(e)
		{
		
		}
	}
}

function compareAllParts(partNumber)
{
	if (window.pdatamanager != undefined)
	{
		var form = document.getElementById('form_' + partNumber);
		if (form != null)
		{
			try
			{
				var pClassification = form.classification.value;
				var pClassId = form.classid.value;
				var pLineId = form.lineid.value;
				var pLineSubId = form.linesubid.value;
				
				pdatamanager.clearCompareParts();
				pdatamanager.addComparePart(pClassification, pClassId, fixId(pLineId), fixId(pLineSubId));
				
				var childList = form.childlist.value;
				var params = childList.split(",");
				if (params.length % 4 == 0)
				{
					for (var i = 0; i < params.length - 3; i += 4)
					{
						pdatamanager.addComparePart(params[i], params[i + 1], parseInt(params[i + 2]), parseInt(params[i + 3]));
					}
				}
				pdatamanager.showPartCompare();
        pdatamanager.moveToOrigPos();
			}
			catch(e)
			{
			
			}
		}
	}
}

function CollapseAllBlocks()
{

  var params = getUrlParameters();
  var part_id = params['part_id'];
  if (part_id != undefined && part_id != "")
  {
    $('a#' + part_id).find('div.LeftPartPicContainer, div.RightPartPicContainer').addClass('highlight');
  }
  
	var  i = 1;
	while (document.getElementById('td_' + i) != null)
	{
  
    var hasSearchResult = $('#td_' + i).find('.highlight').length;
    
    if (hasSearchResult == 0) {
      CollapseSearchResults(i);
    }    
		
		i++;
	}

}

function CollapseSearchResults(partId)
{
	var td = document.getElementById('td_' + partId);
	if (td != null)
	{
		var id = '#td_' + partId;
		var i=0;
		$(id).find('.RightPartPicContainer').each(function() {
			i++;
			if (i > 3) {
				$(this).hide();	
			}
		});
		$('#less_'+partId).hide();
		$('#more_'+partId).show();
	}
}

function ExpandSearchResults(partId)
{ 	
	var td = document.getElementById('td_' + partId);
	if (td != null)
	{
		var id = '#td_' + partId;
		var i=0;
		$(id).find('.RightPartPicContainer').show();
		$('#less_'+partId).show();
		$('#more_'+partId).hide();
	}
}

//functions for duplicate report calculations
function FormatPrice(price)
{
	value = parseInt(price * 100);
	value = value / 100;
	value = value.toFixed(0);
	value = value.replace(/\./,',');
	while(value.match(/^(\d+)(\d{3}\b)/))
		value = value.replace(/^(\d+)(\d{3}\b)/, RegExp.$1 + '.' + RegExp.$2);
	return value;
}

function calculateSavings()
{
	var SampleCount = parseInt(document.getElementById('SampleCount').firstChild.nodeValue);
	var DuplicateCount = parseInt(document.getElementById('DuplicateCount').firstChild.nodeValue);
	var totalParts = document.Formular.AllParts.value;
	var estimate = document.Formular.MaybeDuplicates.value;
	var PartFees = document.Formular.PartFees.value;
	
	var PossibleDuplicates = (DuplicateCount/SampleCount) * totalParts;
	var test = document.createTextNode(FormatPrice(PossibleDuplicates));
	if (document.getElementById('PossibleDuplicates').hasChildNodes())
	{
		var node = document.getElementById('PossibleDuplicates').firstChild;
		document.getElementById('PossibleDuplicates').removeChild(node);
	}
	document.getElementById('PossibleDuplicates').appendChild(test);

	var TotalEstimate = PossibleDuplicates * (estimate / 100);
	TotalEstimate = parseInt(TotalEstimate + 1);
	var test2 = document.createTextNode(FormatPrice(TotalEstimate));
	if (document.getElementById('TotalEstimate').hasChildNodes())
	{
		var node2 = document.getElementById('TotalEstimate').firstChild;
		document.getElementById('TotalEstimate').removeChild(node2);
	}
	document.getElementById('TotalEstimate').appendChild(test2);

	var TotalSavings = PartFees*TotalEstimate;
	var test3 =document.createTextNode(FormatPrice(TotalSavings));
	if (document.getElementById('TotalSavings').hasChildNodes())
	{
		var node3 = document.getElementById('TotalSavings').firstChild;
		document.getElementById('TotalSavings').removeChild(node3);
	}
	document.getElementById('TotalSavings').appendChild(test3);
}

function selectPart(page, anchor)
{
  var newUrl = "html/" + page + "_sorted.html?part_id=" + anchor + "&" + new Date().getTime() + "#" + anchor;
  top.frames.content.window.location.href = newUrl;
}

function getUrlParameters()
{
    var params = []
    var hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for (var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        params.push(hash[0]);
        params[hash[0]] = hash[1];
    }
    return params;
}