
function fixId(id)
{
	if (id=='')
	  return -1;
    if (typeof(id)=='string')
	  return parseInt(id);
     return id;
}

function openDirectory(classification, classId)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openDirectory(classification, classId);
	}
}

function openCatalog(catalog)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openCatalog(catalog);
	}
}

function openPart(classification, classId, lineId, lineSubId)
{
	if (window.pdatamanager != undefined)
	{
		pdatamanager.openPart(classification, classId, fixId(lineId), fixId(lineSubId));
	}
}

function comparePart(partNumber, classification, classId, lineId, lineSubId)
{
	var form = document.getElementById('form_' + partNumber);
	if (form != null)
	{
		try
		{
			var pClassification = form.classification.value;
			var pClassId = form.classid.value;
			var pLineId = form.lineid.value;
			var pLineSubId = form.linesubid.value;
			
			if (window.pdatamanager != undefined)
			{
				pdatamanager.clearCompareParts();
				pdatamanager.comparePart(pClassification, pClassId, fixId(pLineId), fixId(pLineSubId), classification, classId, fixId(lineId), fixId(lineSubId));
			}
		}
		catch(e)
		{
		
		}
	}
}

function compareAllParts(partNumber)
{
	if (window.pdatamanager != undefined)
	{
		var form = document.getElementById('form_' + partNumber);
		if (form != null)
		{
			try
			{
				var pClassification = form.classification.value;
				var pClassId = form.classid.value;
				var pLineId = form.lineid.value;
				var pLineSubId = form.linesubid.value;
				
				pdatamanager.clearCompareParts();
				pdatamanager.addComparePart(pClassification, pClassId, fixId(pLineId), fixId(pLineSubId));
				
				var childList = form.childlist.value;
				var params = childList.split(",");
				if (params.length % 4 == 0)
				{
					for (var i = 0; i < params.length - 3; i += 4)
					{
						pdatamanager.addComparePart(params[i], params[i + 1], parseInt(params[i + 2]), parseInt(params[i + 3]));
					}
				}
				pdatamanager.showPartCompare();
			}
			catch(e)
			{
			
			}
		}
	}
}

function CollapseAllBlocks()
{

  var params = getUrlParameters();
  var part_id = params['part_id'];
  if (part_id != undefined && part_id != "")
  {
    $('a#' + part_id).find('div.LeftPartPicContainer, div.RightPartPicContainer').addClass('highlight');
  }
  
	var  i = 1;
	while (document.getElementById('td_' + i) != null)
	{
  
    var hasSearchResult = $('#td_' + i).find('.highlight').length;
    
    if (hasSearchResult == 0) {
      CollapseSearchResults(i);
    }    
		
		i++;
	}

}

function CollapseSearchResults(partId)
{
	var td = document.getElementById('td_' + partId);
	if (td != null)
	{
		var id = '#td_' + partId;
		var i=0;
		$(id).find('.RightPartPicContainer').each(function() {
			i++;
			if (i > 3) {
				$(this).hide();	
			}
		});
		$('#less_'+partId).hide();
		$('#more_'+partId).show();
	}
}

function ExpandSearchResults(partId)
{ 	
	var td = document.getElementById('td_' + partId);
	if (td != null)
	{
		var id = '#td_' + partId;
		var i=0;
		$(id).find('.RightPartPicContainer').show();
		$('#less_'+partId).show();
		$('#more_'+partId).hide();
	}
}