/************************* ON CLICK HANDLER **************************/
var clickProcessing = false;
// General click event:
function onJQueryGetClick()
{
  // Double clicks will cause problems otherwise:
  if(clickProcessing)
    return;
  else
  {
    // Set flag:
    clickProcessing = true;
    // Revert:
    window.setTimeout(function() { clickProcessing = false; }, 750);
  }
  
  // Parse video action and show it:
  if( $(this).data('mp4') )
    showVideo($(this).data('name'), $(this).data('description'), $(this).data('mp4'));

  // Extra objects to hide:
  var hide = $(this).data('hide');
  
  if(hide)
    $(hide).css('opacity', '0.0');
    
  // Extra objects to hide and revert:
  var hideandrevert = $(this).data('hideandrevert');
  
  if(hideandrevert)
  {
    // Hide:
    $(hideandrevert).css('opacity', '0.0');
    // Revert:
    window.setTimeout(function() { $(hideandrevert).css('opacity', '1.0'); }, 1000);
  }
  
  /*************************** ANIMATIONS ****************************/

  // Container:
  var outc = $($(this).data('out'));
  var inc = $($(this).data('in'));
  var outcValid = outc.length;
  var incValid = inc.length;
  
  if(outcValid)
  {
    // Swipe direction:
    var direction = $(this).data('direction');
    // Extra container to empty:
    var empty = $(this).data('empty');
    
    // Animation for fading:
    if(direction === 'fade')
    {
      if(!incValid)
        outc.fadeOut(speed, function() { window.setTimeout(function() { outc.show(); }, 2000); }); // Fade out and revert.
      else
      {
        // Fade out and set container to inactive.
        outc.fadeOut(speed, function() { afterChange(outc, inc, empty); });
        // Call to fade in next container:
        beforeChange(inc);
      }
    }
    
    // Animation for left swipe:
    if(direction === 'left')
    {
      if(!incValid)
        outc.animate({ left: '-=3000' }, speed * 2, function() { window.setTimeout(function() { outc.css('left', '0'); }, 2000); });
      else
      {
        // Swipe to left and set container to inactive.
        outc.animate({ left: '-=3000' }, speed * 2, function() { afterChange(outc, inc, empty); });
        // Call to fade in next container:
        beforeChange(inc);
      }
    }

    // Animation for top swipe:
    if(direction === 'top')
    {
      if(!incValid)
        outc.animate({ top: '-=3000' }, speed * 2, function() { window.setTimeout(function() { outc.css('top', '0'); }, 2000); });
      else
      {
        // Swipe to top and set container to inactive.
        outc.animate({ top: '-=3000' }, speed * 2, function() { afterChange(outc, inc, empty); });
        // Call to fade in next container:
        beforeChange(inc);
      }
    }

    // Animation for right swipe:
    if(direction === 'right')
    {
      if(!incValid)
        outc.animate({ right: '-=3000' }, speed * 2, function() { window.setTimeout(function() { outc.css('right', '0'); }, 2000); });
      else
      {
        // Swipe to right and set container to inactive.
        outc.animate({ right: '-=3000' }, speed * 2, function() { afterChange(outc, inc, empty); });
        // Call to fade in next container:
        beforeChange(inc);
      }
    }
  }
    
  /************************* AJAX CALLBACK ***************************/

  // Parse action:
  var action = $(this).data('action');

  if(action && action.length)
  { // Special actions:
    if(action === 'videos')
      listVideos('#videos', '#videos .jquery_get');
    else // Default action:
      $.get($('#AJAX_CALLBACK').val() + '&save=' + ($('#save').prop('checked') ? '1' : '0') + '&option=' + action);
  }
  
  // Extra call to sequencer?
  if($(this).data('sequencer'))
    sequencer();
}

/************************ CALLBACK FUNCTIONS *************************/

// Toggle classes and reset all inline css:
function afterChange(inOutC, inInC, inEmpty)
{
  inOutC.toggleClass('inactive active').removeAttr('style');
  if(inOutC.attr('id') != 'videos' && 0 == inOutC.parents('#videos').length) // WORKAROUND!
    inOutC.find('.jquery_get').removeAttr('style');
  inInC.toggleClass('inactive active').removeAttr('style');
  
  if(inEmpty)
    $(inEmpty).empty();
}

// Fade for inactive while active floats to side:
function beforeChange(inInC)
{
  inInC.fadeTo(speed, 1);
}

/******************* SEQUENCER FOR ELEMENT FADEIN ********************/

function sequencer()
{
  var i = 0;

  $('.jquery_get').each(
    function()
    {
      // animate
      $(this).delay(i * speed / 2).fadeIn(speed * 1.5);
      // increment
      ++i;
    }
  );
  // video overlay
  $('.thumbContainer').prepend('<div class="overlay"></div>');
}

/************************* DYNAMIC CONTENT FUNCTIONS **************************/

function listVideos(inObjectIds, inObjectIdsNew)
{
  $.getJSON($('#AJAX_CALLBACK').val() + '&save=' + ($('#save').prop('checked') ? '1' : '0') + '&option=tile_right',
    function(inData)
    { // test if response ok
      if(typeof(inData) != 'undefined')
      {
        var max = Math.ceil(inData.length / 12);
        var html = '<h1>' + $('#HEAD_VIDEOS').val() + '</h1>';
        html += '<div class="videoindexBack" data-direction="right" data-hide=".videoindexBack" data-sequencer="1" data-in="#main" data-out="#videos" data-empty="#videos"></div>';

        // iterate through the list
        for(var j = 0, i = 0; j < max; ++j)
        {
          if(0 == j)
          {
            html += '<div id="videos' + j + '" class="container active">';
            html += '  <div id="left' + j + '" class="videoindexLeftDisabled"></div>';
          }
          else
          {
            html += '<div id="videos' + j + '" class="container inactive">';
            html += '  <div id="left' + j + '" class="videoindexLeft" data-hideandrevert="#left' + j + ', #right' + j + '" data-direction="right" data-in="#videos' + (j - 1) + '" data-out="#videos' + j + '"></div>';
          }
          html += '  <div class="videoindexInside">'
          
          for(; i < ((j + 1) * 12) && i < inData.length; ++i)
          {
            html += '    <div class="' + (0 == j ? 'jquery_get' : 'clickable') + ' videoCaller" data-name="' + (inData[i].name ? inData[i].name : '' ) + '" data-description="' + (inData[i].description ? inData[i].description : '') + '" data-mp4="' + inData[i].mp4 + '" data-direction="fade" data-in="#video" data-out="#videos">';
            html += '      <div class="thumbContainer">';
            html += '        <img src="' + inData[i].thumbnail + '">';
            html += '      </div>';
            html += '      <h2>' + (inData[i].name ? inData[i].name : '') + '</h2>';
            html += '    </div>';
          }
          html += '  </div>';
          
          if(j < (max - 1))
          {
            html += '<div id="right' + j + '" class="videoindexRight" data-hideandrevert="#left' + j + ', #right' + j + '" data-direction="left" data-in="#videos' + (j + 1) + '" data-out="#videos' + j + '"></div>';
          }
          else
          {
            html += '<div id="right' + j + '" class="videoindexRightDisabled"></div>';
          }
          html += '</div>';
        }
        html += '<div style="clear: both;"></div>';
        // inner html
        $(inObjectIds).html(html);
        // initialize tiles
        $(inObjectIdsNew).click(onJQueryGetClick);
        // initialize buttons
        $('.videoindexBack').click(onJQueryGetClick);
        $('.videoindexLeft').click(onJQueryGetClick);
        $('.videoindexRight').click(onJQueryGetClick);
        // fade in tiles
        sequencer();
      }
    }
  );
}

function showVideo(inName, inDescription, inMP4)
{
  var html = '<h1 class="videoTitle">' + inName + '</h1>';
  html += '<div class="videoindexBack" data-direction="fade" data-in="#videos" data-out="#video" data-empty="#video"></div>';
  html += '<div class="videoCloseHelper"><div class="videoClose" style="background-image:url(\'' + $('#FILE_CLOSE').val() + '\');" data-direction="fade" data-in="#videos" data-out="#video" data-empty="#video"></div></div>';
  html += '<div class="videoWrapper">';

  if(inMP4)
    {
      html += '<video id="video-container" width="100%" height="100%" controls>';
      html += '<source src="' + inMP4 + '" type="video/webm">';
      html += '</video>';
    }  
    
  html += '</div>';
  html += '<div class="videoDescription">' + inDescription + '</div>';
  // inner html
  $('#video').html(html);
  // initialize close button
  
  var video_container = document.getElementById("video-container");
  
  video_container.load();
  video_container.play();
  
  $('.videoindexBack').click(onJQueryGetClick);
  $('.videoClose').click(onJQueryGetClick);
}

/************************* HELPER FUNCTIONS **************************/

function check()
{
  if($('#save').prop('checked'))
    $('#save').prop('checked', false);
  else
    $('#save').prop('checked', true);
}
